import { world, Vector, system, ItemStack, ItemTypes } from "@minecraft/server";
import { ActionFormData } from "@minecraft/server-ui";

const damagePerMaterial = new Map([
    ['netherite_greatsword', 32],
    ['iron_greatsword', 23],
    ['stone_greatsword', 12],
    ['netherite_longsword', 14],
    ['diamond_longsword', 12],
    ['iron_longsword', 8],
    ['golden_longsword', 7],
    ['stone_longsword', 7],
    ['wooden_longsword', 6],
    ['netherite_lance', 13],
    ['diamond_lance', 11],
    ['iron_lance', 9],
    ['golden_lance', 8],
    ['stone_lance', 8],
    ['wooden_lance', 7],
    ['netherite_wakizashi', 7],
    ['diamond_wakizashi', 6],
    ['iron_wakizashi', 5],
    ['golden_wakizashi', 5],
    ['stone_wakizashi', 4],
    ['wooden_wakizashi', 3],
    ['netherite_katana', 8],
    ['diamond_katana', 7],
    ['iron_katana', 6],
    ['iron_odachi', 16],
    ['golden_katana', 6],
    ['stone_katana', 5],
    ['wooden_wakizashi', 3],
    ['netherite_glaive', 10],
    ['diamond_glaive', 9],
    ['iron_glaive', 7],
    ['golden_glaive', 7],
    ['stone_glaive', 6],
    ['wooden_glaive', 5],
    ['netherite_mace', 7],
    ['diamond_mace', 6],
    ['iron_mace', 5],
    ['golden_mace', 5],
    ['stone_mace', 4],
    ['wooden_mace', 3],
    ['netherite_rapier', 7],
    ['diamond_rapier', 6],
    ['iron_rapier', 5],
    ['golden_rapier', 5],
    ['netherite_dagger', 7],
    ['diamond_dagger', 6],
    ['iron_dagger', 5],
    ['golden_dagger', 5],
    ['stone_dagger', 4],
    ['wooden_dagger', 3],
    ['netherite_katar', 7],
    ['diamond_katar', 6],
    ['iron_katar', 5],
    ['golden_katar', 5],
    ['stone_katar', 4],
    ['wooden_katar', 3],
    ['netherite_saber', 7],
    ['diamond_saber', 6],
    ['iron_saber', 5],
    ['golden_saber', 5],
    ['stone_saber', 4],
    ['wooden_saber', 3],
    ['netherite_halberd', 7],
    ['diamond_halberd', 6],
    ['iron_halberd', 5],
    ['golden_halberd', 5],
    ['stone_halberd', 4],
    ['wooden_halberd', 3],
    ['netherite_spear', 7],
    ['diamond_spear', 6],
    ['iron_spear', 5],
    ['golden_spear', 5],
    ['stone_spear', 4],
    ['wooden_spear', 3],
    ['pole_hammer', 7],
    ['bec_de_corbin', 6]
]);

const enemyDefense = new Map([
    ['netherite_helmet', 3],
    ['netherite_chestplate', 8],
    ['netherite_leggings', 7],
    ['netherite_boots', 3],
    ['diamond_helmet', 3],
    ['diamond_chestplate', 8],
    ['diamond_leggings', 6],
    ['diamond_boots', 3],
    ['iron_helmet', 2],
    ['iron_chestplate', 6],
    ['iron_leggings', 5],
    ['iron_boots', 2],
    ['golden_helmet', 2],
    ['golden_chestplate', 5],
    ['golden_leggings', 3],
    ['golden_boots', 1],
    ['chainmail_helmet', 2],
    ['chainmail_chestplate', 5],
    ['chainmail_leggings', 4],
    ['chainmail_boots', 1],
    ['leather_helmet', 1],
    ['leather_chestplate', 3],
    ['leather_leggings', 2],
    ['leather_boots', 1],
])



const polcat = ["p","q","w","e","r","t","y","u","i","o","qp","qq","qw","qe","qr","qt","qy","qu","qi","qo","wp","wq","ww","we","wr","wt","wy","wu","wi","wo","ep","eq","ew","ee","er","et","ey","eu","ei","eo","rp","rq","rw","re","rr","rt","ry","ru","ri","ro","tp","tq","tw","te","tr","tt","ty","tu","ti","to","yp","yq","yw","ye","yr","yt","yy","yu","yi","yo","up"]
 
function fetchScore(player, objc) {
  return world.scoreboard.getObjective(objc).getScore(player.scoreboardIdentity)
}

function coordExtractor(player) {
    let locArray = JSON.stringify(player.location).split(":")
    let xg = parseFloat(locArray[1].replace(",\"y\"", ""))
    let ygb = parseFloat(locArray[2].replace(",\"z\"", ""))
    let yg = ygb + 1
    let zg = parseFloat(locArray[3])
    return new Vector(xg,yg,zg);
}

function enemyArmorCalculator(enemy, Map) {
      let eHelm
      let eChest
      let eLegs
      let eBoots
      
      let helm = enemy.getComponent('equipment_inventory').getEquipment('head')
      
     helm != undefined ? eHelm = enemyDefense.get(helm.typeId.split(':')[1]) : eHelm = 0
     
      let chest = enemy.getComponent('equipment_inventory').getEquipment('chest')
      
     chest != undefined ? eChest = enemyDefense.get(chest.typeId.split(':')[1]) : eChest = 0
      
      let legs = enemy.getComponent('equipment_inventory').getEquipment('legs')
      
     legs != undefined ? eLegs = enemyDefense.get(legs.typeId.split(':')[1]) : eLegs = 0
      
      let feet = enemy.getComponent('equipment_inventory').getEquipment('feet')
      
     feet != undefined ? eBoots = enemyDefense.get(feet.typeId.split(':')[1]) : eBoots = 0
     
    let calcs = parseFloat((eHelm + eChest + eLegs + eBoots) / 2)
    return calcs
}

function weaponTypeIterator(item) {
    if (item.includes("wakizashi")) {
       return "wakizashi";
    } else if (item.includes("saber")) {
       return "saber";
    } else if (item.includes("greatsword")) {
       return "greatsword";
    } else if (item.includes("halberd")) {
       return "halberd";
    } else if (item.includes("rapier")) {
       return "rapier";
    } else if (item.includes("dagger")) {
       return "dagger";
    } else if (item.includes("katar")) {
       return "katar";
    } else if (item.includes("mace")) {
       return "mace";
    } else if (item.includes("longsword")) {
       return "longsword";
    } else if (item.includes("odachi")) {
       return "odachi";
    } else if (item.includes("katana")) {
       return "katana";
    } else if (item.includes("spear")) {
       return "spear";
    } else if (item.includes("glaive")) {
       return "glaive";
    } else if (item.includes("pole_hammer")) {
       return "pole_hammer";
    } else if (item.includes("corbin")) {
       return "corbin";
    } else if (item.includes("hand_blaster")) {
       return "hand_blaster";
    } else if (item.includes("lance")) {
       return "lance";
    } else {
       return "unidentified";
    } 
}

function spearTypeIterator(item) {
    if (item.includes(`netherite`)) {
       return `netherite`;
    } else if (item.includes(`diamond`)) {
       return `diamond`;
    } else if (item.includes(`iron`)) {
       return `iron`;
    } else if (item.includes(`gold`)) {
       return `gold`;
    } else if (item.includes(`stone`)) {
       return `stone`;
    } else if (item.includes(`wooden`)) {
       return `wooden`;
    }
}

function katanaTypeIterator(item) {
    if (item.includes(`netherite`)) {
       return `netherite_katana`;
    } else if (item.includes(`diamond`)) {
       return `diamond_katana`;
    } else if (item.includes(`iron`)) {
       return `iron_katana`;
    } else if (item.includes(`gold`)) {
       return `golden_katana`;
    } else if (item.includes(`stone`)) {
       return `stone_katana`;
    } else if (item.includes(`wooden`)) {
       return `wooden_katana`;
    }
}

function wakizashiTypeIterator(item) {
    if (item.includes(`netherite`)) {
       return `netherite_wakizashi`;
    } else if (item.includes(`diamond`)) {
       return `diamond_wakizashi`;
    } else if (item.includes(`iron`)) {
       return `iron_wakizashi`;
    } else if (item.includes(`gold`)) {
       return `golden_wakizashi`;
    } else if (item.includes(`stone`)) {
       return `stone_wakizashi`;
    } else if (item.includes(`wooden`)) {
       return `wooden_wakizashi`;
    }
}

world.afterEvents.playerSpawn.subscribe((data) =>{
    let joiner = data.player
    joiner.runCommandAsync("execute as @s run function cdmover")
})

system.run(async function tick() {
  system.run(tick);
  for (const player of world.getPlayers()) {
    const inv = player.getComponent("inventory").container.getItem(player.selectedSlot);
    if (inv == undefined) {
        player.runCommandAsync("execute as @s run function weapons/reset");
        return;
    }
    let peak = player.isSneaking
    let jupm = fetchScore(player, "jump");
    let spur = fetchScore(player, "sprint");
    if (jupm > 0 && peak == true) {
        player.runCommandAsync("scoreboard players remove @s exhaust 10")
        const dodgen = system.runInterval(() => {
         player.runCommandAsync(`teleport @s ^^0.1^-0.75 true`);
        });
        system.runTimeout(() => {
	     system.clearRun(dodgen);
        },3);
        
    }
    if (jupm > 0 && spur > 0) {
        player.runCommandAsync("scoreboard players remove @s exhaust 10")
        player.runCommandAsync("execute at @s run summon pixel:propel ^^^-1")
    }
    let blue = weaponTypeIterator(inv.typeId)
    if (blue != "unidentified") {
       player.addEffect("weakness", 20, { amplifier: 100, showParticle: false })
    }
  }
});

world.afterEvents.entityHit.subscribe((entityData) => {
    let cali = entityData.entity
    let burn = entityData.hitEntity
    let nali = entityData.hitBlock
    let forgis = cali.getComponent('equipment_inventory').getEquipment('offhand')
    let jorgis
    forgis == undefined ? jorgis = "noname" : jorgis = forgis.typeId
    let gorgis = weaponTypeIterator(jorgis)
    let stunned = fetchScore(cali, "stunned");
    let ride = fetchScore(cali, "rider");
    let attck = fetchScore(cali, "attacking");
    if (cali.typeId === "minecraft:player") {
      const inv = cali.getComponent("inventory").container.getItem(cali.selectedSlot);
      if (inv == undefined) return;
      let red = inv.typeId.split('_');
      let green = red[0].split(':');
      let yellow = inv.typeId.split(':');
      let violet = katanaTypeIterator(inv.typeId)
      let indigo = wakizashiTypeIterator(inv.typeId)
      let critChance = Math.floor(Math.random()*3)
      let critDamage = 0
        critChance != 2 ? critDamage = 0 :inv.typeId.includes("wakizashi") ? critDamage = Math.floor(Math.random()* damagePerMaterial.get(indigo)) : inv.typeId.includes("katana") ? critDamage = Math.floor(Math.random()* damagePerMaterial.get(violet)) : critDamage = Math.floor(Math.random()* damagePerMaterial.get(yellow[1])) ;
      
    let loc = coordExtractor(cali)
      const frontLoc = Vector.add(loc, Vector.multiply(cali.getViewDirection(), 2));
    if (inv.hasTag("damage:deconstructor")) {
        let justify = inv.getTags();
        if (justify.includes("minecraft:is_spear")) {
            cali.runCommandAsync(`say @s tentnen`)
        }
    }
    let imv = inv.getComponent("durability").damage + 1
    if (attck == 1) {
       entityData.cancel
       return;
    }
    let atkspd
    let sneak = cali.isSneaking
    let blue = weaponTypeIterator(inv.typeId)
    let kick = inv.hasComponent("durability")
    if (blue == "unidentifed") {
        return;
    }
    if (kick == false) {
        return;
    }
    if (burn == undefined) {
        return;
    } else if (ride == 1) {
            switch (blue){
              case "rapier":
                 cali.runCommandAsync("scoreboard players set @s attacking 1");
                 cali.runCommandAsync(`replaceitem entity @s slot.weapon.mainhand 0 pixel:${green[1]}_rapier 1 ${imv}`);
                 cali.addTag("rpr")
                 let rprcmb = fetchScore(cali, "rpr_cmb"); 
                 rprcmb != 2 ? atkspd = 4 : atkspd = 6
                  cali.runCommandAsync("execute as @s run function weapons/rapier/rapier_ride_tick")
                 const rapiers = system.runInterval(() => {
                   cali.runCommandAsync("execute as @s run function weapons/rapier/rapier_after");
                   if (stunned == 1) {
                       system.clearRun(rapiers);
                       return;
                   } else if (stunned == 0) {
                     let dmg = damagePerMaterial.get(yellow[1]) + critDamage;
                     let hghdmg = dmg + critDamage + 3
                     if (rprcmb != 2){
                        let projectiles = world.getDimension("overworld").spawnEntity("pixel:rapier_hit",frontLoc)
                        projectiles.triggerEvent(`damage:${polcat[dmg]}`);
                          burn.applyDamage(dmg, {damagingProjectile: projectiles ,damagingEntity: cali })
                     } else if (rprcmb == 2){
                        let projectiles = world.getDimension("overworld").spawnEntity("pixel:rapier_hit",frontLoc)
                        projectiles.triggerEvent(`damage:${polcat[dmg]}`);
                          burn.applyDamage(hghdmg, {damagingProjectile: projectiles ,damagingEntity: cali })
                     }
                   }
                   system.clearRun(rapiers);
              },atkspd);
              break;
              case "saber":
                 cali.runCommandAsync("scoreboard players set @s attacking 1");
                 cali.runCommandAsync(`replaceitem entity @s slot.weapon.mainhand 0 pixel:${green[1]}_saber 1 ${imv}`);
                 cali.addTag("sbr");
                 let sbrcmb = fetchScore(cali, "sbr_cmb");
                 sbrcmb != 2 ? atkspd = 6 : atkspd = 10
                 
                   cali.runCommandAsync("execute as @s run function weapons/saber/saber_ride_tick");
                 const sabers = system.runInterval(() => {
                   cali.runCommandAsync("execute as @s run function weapons/saber/saber_after");
                   if (stunned == 1) {
                       system.clearRun(sabers);
                       return;
                   } else if (stunned == 0) {
                     let dmg = damagePerMaterial.get(yellow[1]) + critDamage;
                     let hghdmg = dmg + critDamage + 6
                     if (sbrcmb != 2){
                        let projectiles = world.getDimension("overworld").spawnEntity("pixel:saber_hit",frontLoc)
                        projectiles.triggerEvent(`damage:${polcat[dmg]}`);
                          burn.applyDamage(dmg, {damagingProjectile: projectiles ,damagingEntity: cali })
                     } else if (sbrcmb == 2){
                        let projectiles = world.getDimension("overworld").spawnEntity("pixel:saber_hit",frontLoc)
                        projectiles.triggerEvent(`damage:${polcat[dmg]}`);
                          burn.applyDamage(hghdmg, {damagingProjectile: projectiles ,damagingEntity: cali })
                     }
                   }
                   system.clearRun(sabers);
              },atkspd);
              break;
              case "katana":
                 cali.runCommandAsync("scoreboard players set @s attacking 1");
                 cali.runCommandAsync(`replaceitem entity @s slot.weapon.mainhand 0 pixel:${green[1]}_katana 1 ${imv}`);
                 cali.addTag("ktn");
                 let ktncmb = fetchScore(cali, "ktn_cmb");
                 let fnlktn = fetchScore(cali, "fnlktn");
                  atkspd = 10
                  let reapers = burn.getComponent("health").current;
                   cali.runCommandAsync("execute as @s run function weapons/katana/katana_ride_tick");
                   cali.addEffect("slowness", 10, { amplifier: 2, showParticle: false })
                 const katanas = system.runInterval(() => {
                   cali.runCommandAsync("execute as @s run function weapons/katana/katana_after");
                   if (stunned == 1) {
                       system.clearRun(daggers);
                       return;
                   } else if (stunned == 0) {
                   if (fnlktn == 1 && reapers < 5) {
                      let roc = coordExtractor(burn)
                      const frontRoc = Vector.add(roc, Vector.multiply(cali.getViewDirection(), 2));
                      burn.addEffect("weakness", 25, { amplifier: 100, showParticle: false });
                      burn.addEffect("slowness", 25, { amplifier: 100, showParticle: false });
                      cali.tryTeleport(frontRoc, cali.dimension);
                      let btl = system.runInterval(() =>{
                         burn.runCommandAsync(`execute as @s run summon pixel:iaido`)
                       system.clearRun(btl);
                    },20);
                   } else {
                     let dmg = damagePerMaterial.get(violet) + critDamage;
                    let hghdmg = dmg + 4 + critDamage
                       if (ktncmb != 0){
                        let projectiles = world.getDimension("overworld").spawnEntity("pixel:katana_hit",frontLoc)
                        projectiles.triggerEvent(`damage:${polcat[dmg]}`);
                          burn.applyDamage(dmg, {damagingProjectile: projectiles ,damagingEntity: cali })
                       } else if (ktncmb == 0){
                        let projectiles = world.getDimension("overworld").spawnEntity("pixel:katana_hit",frontLoc)
                        projectiles.triggerEvent(`damage:${polcat[hghdmg]}`);
                          burn.applyDamage(hghdmg, {damagingProjectile: projectiles ,damagingEntity: cali })
                     }
                          if (inv == undefined) {
                          cali.runCommandAsync("execute as @s run function weapons/reset");
                       }
                   }
                  }
                  system.clearRun(katanas);
              },atkspd);
              break;
              case "longsword":
                cali.runCommandAsync("scoreboard players set @s attacking 1");
                cali.runCommandAsync(`replaceitem entity @s slot.weapon.mainhand 0 pixel:${green[1]}_longsword 1 ${imv}`);
                cali.addTag("lng");
                let lngcmb = fetchScore(cali, "lng_cmb");
                lngcmb != 2 ? atkspd = 10 : atkspd = 10
                 cali.runCommandAsync("execute as @s run function weapons/longsword/longsword_ride_tick")
                  cali.runCommandAsync("execute as @s run function weapons/longsword/longsword_tick");
                  const longs = system.runInterval(() => {
                   cali.runCommandAsync("execute as @s run function weapons/longsword/longsword_after");
                   if (stunned == 1) {
                       system.clearRun(odachis);
                       return;
                   } else if (stunned == 0) {
                      let dmg = damagePerMaterial.get(yellow[1]) + critDamage;
                      let hghdmg = dmg + critDamage + 5
                      cali.runCommandAsync(`execute as @s[scores={lng_cmb=!2}] run summon pixel:longsword_hit ^^^1.5 damage:${polcat[dmg]}`);
                      cali.runCommandAsync(`execute as @s[scores={lng_cmb=2}] run summon pixel:longsword_hit ^^^1.5 damage:${polcat[hghdmg]}`); 
                      if (inv == undefined) {
                        cali.runCommandAsync("execute as @s run function weapons/reset");
                      }
                   }
                  system.clearRun(longs);
              },atkspd);
              break;
              case "lance":
                cali.runCommandAsync("scoreboard players set @s attacking 1");
                cali.runCommandAsync(`replaceitem entity @s slot.weapon.mainhand 0 pixel:${green[1]}_lance 1 ${imv}`);
                cali.addTag("lnc");
                let lnccmb = fetchScore(cali, "lnc_cmb");
                lnccmb != 2 ? atkspd = 10 : atkspd = 10
                cali.runCommandAsync("execute as @s run function weapons/lance/lance_ride_tick")
                const lances = system.runInterval(() => {
                   cali.runCommandAsync("execute as @s run function weapons/lance/lance_after");
                   if (stunned == 1) {
                       system.clearRun(lances);
                       return;
                   } else if (stunned == 0) {
                      let dmg = damagePerMaterial.get(yellow[1]) + critDamage;
                      let hghdmg = dmg + critDamage + 6
                      if (lnccmb != 2){
                        let projectiles = world.getDimension("overworld").spawnEntity("pixel:lance_hit",frontLoc)
                        projectiles.triggerEvent(`damage:${polcat[dmg]}`);
                          burn.applyDamage(dmg, {damagingProjectile: projectiles ,damagingEntity: cali })
                      } else if (lnccmb == 2){
                        let projectiles = world.getDimension("overworld").spawnEntity("pixel:lance_hit",frontLoc)
                        projectiles.triggerEvent(`damage:${polcat[hghdmg]}`);
                          burn.applyDamage(hghdmg, {damagingProjectile: projectiles ,damagingEntity: cali })
                      }
                   }
                  system.clearRun(lances);
              },atkspd);
              break;
              case "glaive":
                cali.runCommandAsync("scoreboard players set @s attacking 1");
                cali.runCommandAsync(`replaceitem entity @s slot.weapon.mainhand 0 pixel:${green[1]}_glaive 1 ${imv}`);
                cali.addTag("glv");
                let glvcmb = fetchScore(cali, "glv_cmb");
                glvcmb != 2 ? atkspd = 8 : atkspd = 12
                cali.runCommandAsync("execute as @s run function weapons/glaive/glaive_ride_tick");
                const glaives = system.runInterval(() => {
                   let lali = JSON.stringify(cali.id)
                   cali.runCommandAsync("execute as @s run function weapons/glaive/glaive_after");
                   if (stunned == 1) {
                       system.clearRun(glaives);
                       return;
                   } else if (stunned == 0) {
                       let dmg = damagePerMaterial.get(yellow[1]) + critDamage;
                       let hghdmg = dmg + critDamage + 3
                       if (glvcmb != 2){
                        let projectiles = world.getDimension("overworld").spawnEntity("pixel:glaive_hit",frontLoc)
                        projectiles.triggerEvent(`damage:${polcat[dmg]}`);
                          burn.applyDamage(dmg, {damagingProjectile: projectiles ,damagingEntity: cali })
                       } else if (glvcmb == 2){
                        let projectiles = world.getDimension("overworld").spawnEntity("pixel:glaive_hit",frontLoc)
                        projectiles.triggerEvent(`damage:${polcat[hghdmg]}`);
                          burn.applyDamage(hghdmg, {damagingProjectile: projectiles ,damagingEntity: cali })
                       }
                       if (inv == undefined) {
                         cali.runCommandAsync("execute as @s run function weapons/reset");
                        system.clearRun(glaives);
                        return;
                     }
                   }
                system.clearRun(glaives);
              },atkspd);
              break;
              case "spear":
                cali.runCommandAsync("scoreboard players set @s attacking 1");
                cali.runCommandAsync(`replaceitem entity @s slot.weapon.mainhand 0 pixel:${green[1]}_spear 1 ${imv}`);
                cali.addTag("spr");
                let sprcmb = fetchScore(cali, "spr_cmb");
                sprcmb != 2 ? atkspd = 4 : atkspd = 6
                cali.runCommandAsync("execute as @s run function weapons/spear/spear_ride_tick")
                const spears = system.runInterval(() => {
                   cali.runCommandAsync("execute as @s run function weapons/spear/spear_after");
                   if (stunned == 1) {
                       system.clearRun(glaives);
                       return;
                   } else if (stunned == 0) {
                       let dmg = damagePerMaterial.get(yellow[1]) + critDamage;
                       let hghdmg = dmg + critDamage + 3
                       if (sprcmb != 2){
                        let projectiles = world.getDimension("overworld").spawnEntity("pixel:spear_hit",frontLoc)
                        projectiles.triggerEvent(`damage:${polcat[dmg]}`);
                          burn.applyDamage(dmg, {damagingProjectile: projectiles ,damagingEntity: cali })
                       } else if (sprcmb == 2){
                        let projectiles = world.getDimension("overworld").spawnEntity("pixel:spear_hit",frontLoc)
                        projectiles.triggerEvent(`damage:${polcat[hghdmg]}`);
                          burn.applyDamage(hghdmg, {damagingProjectile: projectiles ,damagingEntity: cali })
                       }
                       if (inv == undefined) {
                          cali.runCommandAsync("execute as @s run function weapons/reset");
                          system.clearRun(spears);
                          return;
                     }
                   }
                system.clearRun(spears);
              },atkspd);
              break;
              case "halberd":
                cali.runCommandAsync("scoreboard players set @s attacking 1");
                cali.runCommandAsync(`replaceitem entity @s slot.weapon.mainhand 0 pixel:${green[1]}_halberd 1 ${imv}`);
                cali.addTag("hlbrd");
                let hlbrdcmb = fetchScore(cali, "hlbrd_cmb");
                hlbrdcmb != 2 ? atkspd = 10 : atkspd = 10
                cali.runCommandAsync("execute as @s run function weapons/halberd/halberd_ride_tick");
                const halberds = system.runInterval(() => {
                   cali.runCommandAsync("execute as @s run function weapons/halberd/halberd_after");
                   if (stunned == 1) {
                       system.clearRun(glaives);
                       return;
                   } else if (stunned == 0) {
                       let dmg = damagePerMaterial.get(yellow[1]) + critDamage;
                       let hghdmg = dmg + critDamage + 3
                       cali.runCommandAsync(`execute as @s[scores={glv_cmb=!2}] run summon pixel:halberd_hit ^^^1.5 damage:${polcat[dmg]}`);
                       cali.runCommandAsync(`execute as @s[scores={glv_cmb=2}] run summon pixel:halberd_hit ^^^1.5 damage:${polcat[hghdmg]}`);
                       if (inv == undefined) {
                          cali.runCommandAsync("execute as @s run function weapons/reset");
                          system.clearRun(halberds);
                          return;
                      }
                   }
                system.clearRun(halberds);
              },atkspd);
              break;
             }
    } else {
            switch (blue){
              case "dagger":
                 cali.runCommandAsync("scoreboard players set @s attacking 1");
                 cali.runCommandAsync(`replaceitem entity @s slot.weapon.mainhand 0 pixel:${green[1]}_dagger 1 ${imv}`);
                 let dgrcmb = fetchScore(cali, "dgr_cmb");
                 gorgis == "dagger" ?                 dgrcmb != 2 ? atkspd = 2 : atkspd = 2 : dgrcmb != 2 ? atkspd = 2 : atkspd = 2
                gorgis == "dagger" ? cali.runCommandAsync("execute as @s run function weapons/dagger/dagger_dagger_tick") : cali.runCommandAsync("execute as @s run function weapons/dagger/dagger_tick")

                   const daggers = system.runInterval(() => {
                     if (stunned == 1) {
                         system.clearRun(daggers);
                         return;
                     } else if (stunned == 0) {
                         let dmg = damagePerMaterial.get(yellow[1]) + critDamage
                         let hghdmg = dmg + critDamage + 6
                         if (dgrcmb != 2){
                        let projectiles = world.getDimension("overworld").spawnEntity("pixel:dagger_hit",frontLoc)
                        projectiles.triggerEvent(`damage:${polcat[dmg]}`);
                          burn.applyDamage(dmg, {damagingProjectile: projectiles ,damagingEntity: cali })
                         } else if (dgrcmb == 2){
                        let projectiles = world.getDimension("overworld").spawnEntity("pixel:dagger_hit",frontLoc)
                        projectiles.triggerEvent(`damage:${polcat[hghdmg]}`);
                          burn.applyDamage(hghdmg, {damagingProjectile: projectiles ,damagingEntity: cali })
                         }
                         const dtckcd = system.runInterval(()=>{
                           cali.runCommandAsync("execute as @s run function weapons/dagger/dagger_after");
                           system.clearRun(dtckcd);
                         },2)
                      }
                      system.clearRun(daggers);
                    },atkspd);
              break;
              case "katar":
                 cali.runCommandAsync("scoreboard players set @s attacking 1");
                 cali.runCommandAsync(`replaceitem entity @s slot.weapon.mainhand 0 pixel:${green[1]}_katar 1 ${imv}`);
                 let ktrcmb = fetchScore(cali, "ktr_cmb");
                 ktrcmb != 2 ? atkspd = 4 : atkspd = 6
                 
                   cali.runCommandAsync("execute as @s run function weapons/katar/katar_tick");
                 const katars = system.runInterval(() => {
                   cali.runCommandAsync("execute as @s run function weapons/katar/katar_after");
                   if (stunned == 1) {
                       system.clearRun(katars);
                       return;
                   } else if (stunned == 0) {
                      let dmg = damagePerMaterial.get(yellow[1]) + critDamage;
                      let hghdmg = dmg + critDamage + 5
                      if (ktrcmb != 2){
                        let projectiles = world.getDimension("overworld").spawnEntity("pixel:katar_hit",frontLoc)
                        projectiles.triggerEvent(`damage:${polcat[dmg]}`);
                          burn.applyDamage(dmg, {damagingProjectile: projectiles ,damagingEntity: cali })
                      } else if (ktrcmb == 2){
                        let projectiles = world.getDimension("overworld").spawnEntity("pixel:katar_hit",frontLoc)
                        projectiles.triggerEvent(`damage:${polcat[hghdmg]}`);
                          burn.applyDamage(hghdmg, {damagingProjectile: projectiles ,damagingEntity: cali })
                      }
                   }
                   system.clearRun(katars);
              },atkspd);
              break;
              case "rapier":
                 cali.runCommandAsync("scoreboard players set @s attacking 1");
                 cali.runCommandAsync(`replaceitem entity @s slot.weapon.mainhand 0 pixel:${green[1]}_rapier 1 ${imv}`);
                 let rprcmb = fetchScore(cali, "rpr_cmb");
                jorgis == "minecraft:shield" ? rprcmb != 1 ? atkspd = 6 : atkspd = 8 : gorgis == "dagger" ? rprcmb != 2 ? atkspd = 4 : atkspd = 6 : rprcmb != 2 ? atkspd = 4 : atkspd = 6
                 
                jorgis == "minecraft:shield" ? cali.runCommandAsync("execute as @s run function weapons/rapier/rapier_shield_tick") : gorgis == "dagger" ? cali.runCommandAsync("execute as @s run function weapons/rapier/rapier_dagger_tick") : cali.runCommandAsync("execute as @s run function weapons/rapier/rapier_tick")
                 const rapiers = system.runInterval(() => {
                   cali.runCommandAsync("execute as @s run function weapons/rapier/rapier_after");
                   if (stunned == 1) {
                       system.clearRun(rapiers);
                       return;
                   } else if (stunned == 0) {
                     let dmg = damagePerMaterial.get(yellow[1]) + critDamage;
                     let hghdmg = dmg + critDamage + 3
                     if (rprcmb != 2){
                        let projectiles = world.getDimension("overworld").spawnEntity("pixel:rapier_hit",frontLoc)
                        projectiles.triggerEvent(`damage:${polcat[dmg]}`);
                          burn.applyDamage(dmg, {damagingProjectile: projectiles ,damagingEntity: cali })
                     } else if (rprcmb == 2){
                        let projectiles = world.getDimension("overworld").spawnEntity("pixel:katana_hit",frontLoc)
                        projectiles.triggerEvent(`damage:${polcat[hghdmg]}`);
                          burn.applyDamage(hghdmg, {damagingProjectile: projectiles ,damagingEntity: cali })
                     }
                   }
                   system.clearRun(rapiers);
              },atkspd);
              break;
              case "greatsword":
                 cali.runCommandAsync("scoreboard players set @s attacking 1");
                 cali.runCommandAsync(`replaceitem entity @s slot.weapon.mainhand 0 pixel:${green[1]}_greatsword 1 ${imv}`);
                 cali.addTag("grt");
                 let grtcmb = fetchScore(cali, "grt_cmb");
                 grtcmb != 2 ? atkspd = 15 : atkspd = 30
                 
                   cali.runCommandAsync("execute as @s run function weapons/greatsword/greatsword_tick");
                 const greats = system.runInterval(() => {
                   cali.runCommandAsync("execute as @s run function weapons/greatsword/greatsword_after");
                   if (stunned == 1) {
                       system.clearRun(greats);
                       return;
                   } else if (stunned == 0) {
                      let dmg = damagePerMaterial.get(yellow[1]) + critDamage;
                      let hghdmg = dmg + critDamage + 6
                       if (grtcmb != 2){
                        let projectiles = world.getDimension("overworld").spawnEntity("pixel:great_hit",frontLoc)
                        projectiles.triggerEvent(`damage:${polcat[dmg]}`);
                          burn.applyDamage(hghdmg, {damagingProjectile: projectiles ,damagingEntity: cali })
                       } else if (grtcmb == 2){
                        let projectiles = world.getDimension("overworld").spawnEntity("pixel:great_hit",frontLoc)
                        projectiles.triggerEvent(`damage:${polcat[hghdmg]}`);
                          burn.applyDamage(hghdmg, {damagingProjectile: projectiles ,damagingEntity: cali })
                     }
                   }
                   system.clearRun(greats);
              },atkspd);
              break;
              case "saber":
                 cali.runCommandAsync("scoreboard players set @s attacking 1");
                 cali.runCommandAsync(`replaceitem entity @s slot.weapon.mainhand 0 pixel:${green[1]}_saber 1 ${imv}`);
                 cali.addTag("sbr");
                 let sbrcmb = fetchScore(cali, "sbr_cmb");
                 sbrcmb != 2 ? atkspd = 6 : atkspd = 10
                 
                   cali.runCommandAsync("execute as @s run function weapons/saber/saber_tick");
                 const sabers = system.runInterval(() => {
                   cali.runCommandAsync("execute as @s run function weapons/saber/saber_after");
                   if (stunned == 1) {
                       system.clearRun(sabers);
                       return;
                   } else if (stunned == 0) {
                     let dmg = damagePerMaterial.get(yellow[1]) + critDamage;
                     let hghdmg = dmg + critDamage + 6
                        let projectiles = world.getDimension("overworld").spawnEntity("pixel:saber_hit",frontLoc)
                        projectiles.triggerEvent(`damage:${polcat[dmg]}`);
                          burn.applyDamage(dmg, {damagingProjectile: projectiles ,damagingEntity: cali })
                     } else if (sbrcmb == 2){
                        let projectiles = world.getDimension("overworld").spawnEntity("pixel:saber_hit",frontLoc)
                        projectiles.triggerEvent(`damage:${polcat[hghdmg]}`);
                          burn.applyDamage(hghdmg, {damagingProjectile: projectiles ,damagingEntity: cali })
                   }
                   system.clearRun(sabers);
              },atkspd);
              break;
              case "mace":
                 cali.runCommandAsync("scoreboard players set @s attacking 1");
                 cali.runCommandAsync(`replaceitem entity @s slot.weapon.mainhand 0 pixel:${green[1]}_mace 1 ${imv}`);
                 cali.addTag("mce");
                 let mccmb = fetchScore(cali, "mc_cmb");
                 mccmb != 0 ? atkspd = 6 : atkspd = 10
                   cali.runCommandAsync("execute as @s run function weapons/mace/mace_tick");
                 const maces = system.runInterval(() => {
                   cali.runCommandAsync("execute as @s run function weapons/mace/mace_after");
                   if (stunned == 1) {
                       system.clearRun(maces);
                       return;
                   } else if (stunned == 0) {
                      let dmg = damagePerMaterial.get(yellow[1]) + critDamage;
                      let hghdmg = dmg + critDamage + 6
                      if (mccmb != 0){
                        let projectiles = world.getDimension("overworld").spawnEntity("pixel:mace_hit",frontLoc)
                        projectiles.triggerEvent(`damage:${polcat[dmg]}`);
                          burn.applyDamage(dmg, {damagingProjectile: projectiles ,damagingEntity: cali })
                      } else if (mccmb == 0){
                        let projectiles = world.getDimension("overworld").spawnEntity("pixel:mace_hit",frontLoc)
                        projectiles.triggerEvent(`damage:${polcat[hghdmg]}`);
                          burn.applyDamage(hghdmg, {damagingProjectile: projectiles ,damagingEntity: cali })
                     }
                      system.clearRun(maces);
                   }
              },atkspd);
              break;
              case "katana":
                 cali.runCommandAsync("scoreboard players set @s attacking 1");
                 cali.runCommandAsync(`replaceitem entity @s slot.weapon.mainhand 0 pixel:${green[1]}_katana 1 ${imv}`);
                 cali.addTag("ktn");
                 let ktncmb = fetchScore(cali, "ktn_cmb");
                 let fnlktn = fetchScore(cali, "fnlktn");
                  atkspd = 10
                  let reapers = burn.getComponent("health").current;
                   cali.runCommandAsync("execute as @s run function weapons/katana/katana_tick");
                   cali.addEffect("slowness", 10, { amplifier: 2, showParticle: false })
                 const katanas = system.runInterval(() => {
                   cali.runCommandAsync("execute as @s run function weapons/katana/katana_after");
                   if (stunned == 1) {
                       system.clearRun(daggers);
                       return;
                   } else if (stunned == 0) {
                   if (fnlktn == 1 && reapers < 5) {
                      let roc = coordExtractor(burn)
                      const frontRoc = Vector.add(roc, Vector.multiply(cali.getViewDirection(), 2));
                      burn.addEffect("weakness", 25, { amplifier: 100, showParticle: false });
                      burn.addEffect("slowness", 25, { amplifier: 100, showParticle: false });
                      cali.tryTeleport(frontRoc, cali.dimension);
                      let btl = system.runInterval(() =>{
                         burn.runCommandAsync(`execute as @s run summon pixel:iaido`)
                       system.clearRun(btl);
                    },20);
                   } else {
                     let dmg = damagePerMaterial.get(violet) + critDamage;
                    let hghdmg = dmg + 4 + critDamage
                       if (ktncmb != 0){
                        let projectiles = world.getDimension("overworld").spawnEntity("pixel:katana_hit",frontLoc)
                        projectiles.triggerEvent(`damage:${polcat[dmg]}`);
                          burn.applyDamage(dmg, {damagingProjectile: projectiles ,damagingEntity: cali })
                       } else if (ktncmb == 0){
                        let projectiles = world.getDimension("overworld").spawnEntity("pixel:katana_hit",frontLoc)
                        projectiles.triggerEvent(`damage:${polcat[hghdmg]}`);
                          burn.applyDamage(hghdmg, {damagingProjectile: projectiles ,damagingEntity: cali })
                     }
                          if (inv == undefined) {
                          cali.runCommandAsync("execute as @s run function weapons/reset");
                       }
                   }
                  }
                  system.clearRun(katanas);
              },atkspd);
              break;
              case "odachi":
                 cali.runCommandAsync("scoreboard players set @s attacking 1");
                 cali.runCommandAsync(`replaceitem entity @s slot.weapon.mainhand 0 pixel:${yellow[1]} 1 ${imv}`);
                 cali.addTag("dch");
                 let dchcmb = fetchScore(cali, "dch_cmb");
                 dchcmb != 2 ? atkspd = 14 : atkspd = 14
                   cali.runCommandAsync("execute as @s run function weapons/odachi/odachi_tick");
                 const odachis = system.runInterval(() => {
                   cali.runCommandAsync("execute as @s run function weapons/odachi/odachi_after");
                   if (stunned == 1) {
                       system.clearRun(odachis);
                       return;
                   } else if (stunned == 0) {
                      let dmg = damagePerMaterial.get(yellow[1]) + critDamage;
                      let hghdmg = dmg + critDamage + 6
                       if (dchcmb != 0){
                        let projectiles = world.getDimension("overworld").spawnEntity("pixel:odachi_hit",frontLoc)
                        projectiles.triggerEvent(`damage:${polcat[dmg]}`);
                          burn.applyDamage(hghdmg, {damagingProjectile: projectiles ,damagingEntity: cali })
                       } else if (dchcmb == 0){
                        let projectiles = world.getDimension("overworld").spawnEntity("pixel:odachi_hit",frontLoc)
                        projectiles.triggerEvent(`damage:${polcat[hghdmg]}`);
                          burn.applyDamage(hghdmg, {damagingProjectile: projectiles ,damagingEntity: cali })
                     }
                   }
                  system.clearRun(odachis);
              },atkspd);
              break;
              case "longsword":
                cali.runCommandAsync("scoreboard players set @s attacking 1");
                cali.runCommandAsync(`replaceitem entity @s slot.weapon.mainhand 0 pixel:${green[1]}_longsword 1 ${imv}`);
                cali.addTag("lng");
                let lngcmb = fetchScore(cali, "lng_cmb");
                jorgis == "minecraft:shield" ? lngcmb != 2 ? atkspd = 10 : atkspd = 10 : gorgis == "dagger" ? lngcmb != 2 ? atkspd = 10 : atkspd = 10 : lngcmb != 2 ? atkspd = 10 : atkspd = 10
                
                jorgis == "minecraft:shield" ? cali.runCommandAsync("execute as @s run function weapons/longsword/longsword_shield_tick") : gorgis == "dagger" ? cali.runCommandAsync("execute as @s run function weapons/longsword/longsword_dagger_tick") : cali.runCommandAsync("execute as @s run function weapons/longsword/longsword_tick")
                  cali.runCommandAsync("execute as @s run function weapons/longsword/longsword_tick");
                  const longs = system.runInterval(() => {
                   cali.runCommandAsync("execute as @s run function weapons/longsword/longsword_after");
                   if (stunned == 1) {
                       system.clearRun(odachis);
                       return;
                   } else if (stunned == 0) {
                      let dmg = damagePerMaterial.get(yellow[1]) + critDamage;
                      let hghdmg = dmg + critDamage + 5
                      cali.runCommandAsync(`execute as @s[scores={lng_cmb=!2}] run summon pixel:longsword_hit ^^^1.5 damage:${polcat[dmg]}`);
                      cali.runCommandAsync(`execute as @s[scores={lng_cmb=2}] run summon pixel:longsword_hit ^^^1.5 damage:${polcat[hghdmg]}`); 
                      if (inv == undefined) {
                        cali.runCommandAsync("execute as @s run function weapons/reset");
                      }
                   }
                  system.clearRun(longs);
              },atkspd);
              break;
              case "lance":
                cali.runCommandAsync("scoreboard players set @s attacking 1");
                cali.runCommandAsync(`replaceitem entity @s slot.weapon.mainhand 0 pixel:${green[1]}_lance 1 ${imv}`);
                cali.addTag("lnc");
                let lnccmb = fetchScore(cali, "lnc_cmb");
                jorgis == "minecraft:shield" ? lnccmb != 2 ? atkspd = 10 : atkspd = 10 : lnccmb != 2 ? atkspd = 10 : atkspd = 10
                jorgis == "minecraft:shield" ? cali.runCommandAsync("execute as @s run function weapons/lance/lance_shield_tick") : cali.runCommandAsync("execute as @s run function weapons/lance/lance_tick")
                const lances = system.runInterval(() => {
                   cali.runCommandAsync("execute as @s run function weapons/lance/lance_after");
                   if (stunned == 1) {
                       system.clearRun(lances);
                       return;
                   } else if (stunned == 0) {
                      let dmg = damagePerMaterial.get(yellow[1]) + critDamage;
                      let hghdmg = dmg + critDamage + 6
                      if (lnccmb != 2){
                        let projectiles = world.getDimension("overworld").spawnEntity("pixel:lance_hit",frontLoc)
                        projectiles.triggerEvent(`damage:${polcat[dmg]}`);
                          burn.applyDamage(dmg, {damagingProjectile: projectiles ,damagingEntity: cali })
                      } else if (lnccmb == 2){
                        let projectiles = world.getDimension("overworld").spawnEntity("pixel:lance_hit",frontLoc)
                        projectiles.triggerEvent(`damage:${polcat[hghdmg]}`);
                          burn.applyDamage(hghdmg, {damagingProjectile: projectiles ,damagingEntity: cali })
                      }
                   }
                  system.clearRun(lances);
              },atkspd);
              break;
              case "wakizashi":
                cali.runCommandAsync("scoreboard players set @s attacking 1");
                cali.runCommandAsync(`replaceitem entity @s slot.weapon.mainhand 0 pixel:${yellow[1]} 1 ${imv}`);
                cali.addTag("wkz");
                let wkzcmb = fetchScore(cali, "wkz_cmb");
                wkzcmb != 2 ? atkspd = 6 : atkspd = 10
                cali.runCommandAsync("execute as @s run function weapons/wakizashi/wakizashi_tick");
                const wakizashis = system.runInterval(() => {
                   cali.runCommandAsync("execute as @s run function weapons/wakizashi/wakizashi_after");
                   if (stunned == 1) {
                       system.clearRun(wakizashis);
                       return;
                   } else if (stunned == 0) {
                     let dmg = damagePerMaterial.get(indigo) + critDamage;
                    let hghdmg = dmg + 4 + critDamage
                    if (wkzcmb != 0){
                        let projectiles = world.getDimension("overworld").spawnEntity("pixel:wakizashi_hit",frontLoc)
                        projectiles.triggerEvent(`damage:${polcat[dmg]}`);
                          burn.applyDamage(dmg, {damagingProjectile: projectiles ,damagingEntity: cali })
                    } else if (wkzcmb == 0){
                        let projectiles = world.getDimension("overworld").spawnEntity("pixel:wakizashi_hit",frontLoc)
                        projectiles.triggerEvent(`damage:${polcat[hghdmg]}`);
                          burn.applyDamage(hghdmg, {damagingProjectile: projectiles ,damagingEntity: cali })
                    }
                    if (inv == undefined) {
                           cali.runCommandAsync("execute as @s run function weapons/reset");
                       }
                   }
                system.clearRun(wakizashis);
              },atkspd);
              break;
              case "glaive":
                cali.runCommandAsync("scoreboard players set @s attacking 1");
                cali.runCommandAsync(`replaceitem entity @s slot.weapon.mainhand 0 pixel:${green[1]}_glaive 1 ${imv}`);
                cali.addTag("glv");
                let glvcmb = fetchScore(cali, "glv_cmb");
                glvcmb != 2 ? atkspd = 8 : atkspd = 12
                cali.runCommandAsync("execute as @s run function weapons/glaive/glaive_tick");
                const glaives = system.runInterval(() => {
                   let lali = JSON.stringify(cali.id)
                   cali.runCommandAsync("execute as @s run function weapons/glaive/glaive_after");
                   if (stunned == 1) {
                       system.clearRun(glaives);
                       return;
                   } else if (stunned == 0) {
                       let dmg = damagePerMaterial.get(yellow[1]) + critDamage;
                       let hghdmg = dmg + critDamage + 3
                       if (glvcmb != 2){
                        let projectiles = world.getDimension("overworld").spawnEntity("pixel:glaive_hit",frontLoc)
                        projectiles.triggerEvent(`damage:${polcat[dmg]}`);
                          burn.applyDamage(dmg, {damagingProjectile: projectiles ,damagingEntity: cali })
                       } else if (glvcmb == 2){
                        let projectiles = world.getDimension("overworld").spawnEntity("pixel:glaive_hit",frontLoc)
                        projectiles.triggerEvent(`damage:${polcat[hghdmg]}`);
                          burn.applyDamage(hghdmg, {damagingProjectile: projectiles ,damagingEntity: cali })
                       }
                       if (inv == undefined) {
                         cali.runCommandAsync("execute as @s run function weapons/reset");
                        system.clearRun(glaives);
                        return;
                     }
                   }
                system.clearRun(glaives);
              },atkspd);
              break;
              case "pole_hammer":
                cali.runCommandAsync("scoreboard players set @s attacking 1");
                cali.runCommandAsync(`replaceitem entity @s slot.weapon.mainhand 0 pixel:${green[1]}_hammer 1 ${imv}`);
                cali.addTag("spr");
                let hmrcmb = fetchScore(cali, "hmr_cmb");
                hmrcmb != 2 ? atkspd = 4 : atkspd = 6
                cali.runCommandAsync("execute as @s run function weapons/polehammer/polehammer_tick");
                const hammers = system.runInterval(() => {
                   cali.runCommandAsync("execute as @s run function weapons/polehammer/polehammer_after");
                   if (stunned == 1) {
                       system.clearRun(hammers);
                       return;
                   } else if (stunned == 0) {
                       let dmg = damagePerMaterial.get(yellow[1]) + critDamage;
                       let hghdmg = dmg + critDamage + 3
                       if (hmrcmb != 2){
                        let projectiles = world.getDimension("overworld").spawnEntity("pixel:hammer_hit",frontLoc)
                        projectiles.triggerEvent(`damage:${polcat[dmg]}`);
                          burn.applyDamage(dmg, {damagingProjectile: projectiles ,damagingEntity: cali })
                       } else if (hmrcmb == 2){
                        let projectiles = world.getDimension("overworld").spawnEntity("pixel:hammer_hit",frontLoc)
                        projectiles.triggerEvent(`damage:${polcat[hghdmg]}`);
                          burn.applyDamage(hghdmg, {damagingProjectile: projectiles ,damagingEntity: cali })
                       }
                       if (inv == undefined) {
                          cali.runCommandAsync("execute as @s run function weapons/reset");
                          system.clearRun(hammers);
                          return;
                     }
                   }
                system.clearRun(hammers);
              },atkspd);
              break;
              case "spear":
                cali.runCommandAsync("scoreboard players set @s attacking 1");
                cali.runCommandAsync(`replaceitem entity @s slot.weapon.mainhand 0 pixel:${green[1]}_spear 1 ${imv}`);
                cali.addTag("spr");
                let sprcmb = fetchScore(cali, "spr_cmb");
                jorgis == "minecraft:shield" ? sprcmb != 2 ? atkspd = 4 : atkspd = 6 : sprcmb != 2 ? atkspd = 4 : atkspd = 6
                jorgis == "minecraft:shield" ? cali.runCommandAsync("execute as @s run function weapons/spear/spear_shield_tick") : cali.runCommandAsync("execute as @s run function weapons/spear/spear_tick")
                const spears = system.runInterval(() => {
                   cali.runCommandAsync("execute as @s run function weapons/spear/spear_after");
                   if (stunned == 1) {
                       system.clearRun(glaives);
                       return;
                   } else if (stunned == 0) {
                       let dmg = damagePerMaterial.get(yellow[1]) + critDamage;
                       let hghdmg = dmg + critDamage + 3
                       if (sprcmb != 2){
                        let projectiles = world.getDimension("overworld").spawnEntity("pixel:spear_hit",frontLoc)
                        projectiles.triggerEvent(`damage:${polcat[dmg]}`);
                          burn.applyDamage(dmg, {damagingProjectile: projectiles ,damagingEntity: cali })
                       } else if (sprcmb == 2){
                        let projectiles = world.getDimension("overworld").spawnEntity("pixel:spear_hit",frontLoc)
                        projectiles.triggerEvent(`damage:${polcat[hghdmg]}`);
                          burn.applyDamage(hghdmg, {damagingProjectile: projectiles ,damagingEntity: cali })
                       }
                       if (inv == undefined) {
                          cali.runCommandAsync("execute as @s run function weapons/reset");
                          system.clearRun(spears);
                          return;
                     }
                   }
                system.clearRun(spears);
              },atkspd);
              break;
              case "halberd":
                cali.runCommandAsync("scoreboard players set @s attacking 1");
                cali.runCommandAsync(`replaceitem entity @s slot.weapon.mainhand 0 pixel:${green[1]}_halberd 1 ${imv}`);
                cali.addTag("hlbrd");
                let hlbrdcmb = fetchScore(cali, "hlbrd_cmb");
                hlbrdcmb != 2 ? atkspd = 10 : atkspd = 10
                cali.runCommandAsync("execute as @s run function weapons/halberd/halberd_tick");
                const halberds = system.runInterval(() => {
                   cali.runCommandAsync("execute as @s run function weapons/halberd/halberd_after");
                   if (stunned == 1) {
                       system.clearRun(glaives);
                       return;
                   } else if (stunned == 0) {
                       let dmg = damagePerMaterial.get(yellow[1]) + critDamage;
                       let hghdmg = dmg + critDamage + 3
                       cali.runCommandAsync(`execute as @s[scores={glv_cmb=!2}] run summon pixel:halberd_hit ^^^1.5 damage:${polcat[dmg]}`);
                       cali.runCommandAsync(`execute as @s[scores={glv_cmb=2}] run summon pixel:halberd_hit ^^^1.5 damage:${polcat[hghdmg]}`);
                       if (inv == undefined) {
                          cali.runCommandAsync("execute as @s run function weapons/reset");
                          system.clearRun(halberds);
                          return;
                      }
                   }
                system.clearRun(halberds);
              },atkspd);
              break;
             }
       }
    }
});

//world.beforeEvents.itemUse.subscribe((data) => {
    //let source = data.source
    //let itemID = data.itemStack.typeId
    //if (itemID.includes("pixel")) {
        //const speed = (Math.sqrt(x ** 2 +  z ** 2) * 20).toFixed(1);
        //let sneak = source.isSneaking
        
    //}
//});


world.afterEvents.itemStartCharge.subscribe((data) => {
    let source = data.source
    let itemID = data.itemStack.typeId
    let weaponType = weaponTypeIterator(itemID)
    let loreCheck = data.itemStack.getLore();
    let loc = coordExtractor(source)
    const frontLoc = Vector.add(loc, Vector.multiply(source.getViewDirection(), 2));
    const cont = source.getComponent("minecraft:inventory").container
    const conts = cont.getSlot(source.selectedSlot)
    let jmp = fetchScore(source, "jump");
    let spr = fetchScore(source, "sprint");
    let rdr = fetchScore(source, "rider");
    const { x, z } = source.getVelocity();
    const speed = (Math.sqrt(x ** 2 +  z ** 2) * 20).toFixed(1);
    const item = conts.getItem()
    let sneak = source.isSneaking
    const abilities = system.runInterval(()=>{
    if (rdr == 1) {
        let lance_charge = system.runInterval(() =>{
            let jeke = world.afterEvents.itemStopCharge.subscribe((rdata) => {
                system.clearRun(lance_charge);
                jeke.unsubscribe()
            })
        })
        system.clearRun(abilities)
    } 
    if (weaponType == "hand_blaster") {
        let bulletcount = 3
        let shooter = system.runInterval(() =>{
            const proj = world.getDimension("overworld").spawnEntity("pixel:slash_crescent",frontLoc)
            proj.applyImpulse(source.getViewDirection());
            bulletcount = bulletcount - 1
            if (bulletcount <= 0) {
                system.clearRun(shooter)
            }
        },3);
        system.clearRun(abilities)
    } 
    if (loreCheck == "") {
        switch (weaponType){
          case "lance":
             item.setLore(["§1-Thrust\n§1-Puncture"])
             cont.setItem(source.selectedSlot, item)
          break;
          case "katana":
             item.setLore(["§1-Slash\n§1-Iaido"])
             cont.setItem(source.selectedSlot, item)
          break;
          case "mace":
             item.setLore(["§1-Swing\n§1-Overhead Swing"])
             cont.setItem(source.selectedSlot, item)
          break;
          case "halberd":
             item.setLore(["§1-Slash\n§1-Thrust"])
             cont.setItem(source.selectedSlot, item)
          break;
          case "greatsword":
             item.setLore(["§1-Slash\n§1-Overhead Slash"])
             cont.setItem(source.selectedSlot, item)
          break;
          case "longsword":
             item.setLore(["§1-Guard\n§1-Slash"])
             cont.setItem(source.selectedSlot, item)
          break;
          case "saber":
             item.setLore(["§1-Guard\n§1-Slash"])
             cont.setItem(source.selectedSlot, item)
          break;
          case "odachi":
             item.setLore(["§1-Slash\n§1-Overhead Slash"])
             cont.setItem(source.selectedSlot, item)
          break;
          case "dagger":
             item.setLore(["§1-Stab\n§1-Slash"])
             cont.setItem(source.selectedSlot, item)
          break;
          case "katar":
             item.setLore(["§1-Pierce\n§1-Thrust"])
             cont.setItem(source.selectedSlot, item)
          break;
          case "rapier":
             item.setLore(["§1-Thrust\n§1-Slash"])
             cont.setItem(source.selectedSlot, item)
          break;
          case "wakizashi":
             item.setLore(["§1-Slash\n§1-Iaido"])
             cont.setItem(source.selectedSlot, item)
          break;
          case "spear":
             item.setLore(["§1-Thrust\n§1-Throw"])
             cont.setItem(source.selectedSlot, item)
          break;
          case "glaive":
             item.setLore(["§1-Thrust\n§1-Slash"])
             cont.setItem(source.selectedSlot, item)
          break;
          case "pole_hammer":
             item.setLore(["§1-Swing\n§1-Smash"])
             cont.setItem(source.selectedSlot, item)
          break;
          case "corbin":
             item.setLore(["§1-Thrust\n§1-Swing"])
             cont.setItem(source.selectedSlot, item)
          break;
      }
    } else {
        let ability = loreCheck[0].replace("§1","").replace("\n", "").replace("-","").split('§1')
        let second = ability[1].replace("-","")
        let first = ability[0]
        if (source.isSneaking) {
        const fade =
            new ActionFormData()
                .title('Ability Selector')
                .body('')
                .button(`${second}`)
                .button(`Third Ability`)
                .button(`Fourth Ability`)
                .button(`Fifth Ability`)
                .button(`Sixth Ability`)
                .button(`Seventh Ability`)
                .show(source)
                .then(result => {
                if (result.selection === 0) {
                   item.setLore([`§1-${second}\n§1-${first}`])
                   cont.setItem(source.selectedSlot, item)
                }
                if (result.selection === 1) {}
           })
        } else {
          switch (first){
            case "Slash":
              let slshes = fetchScore(source, "slshcd");
              if (slshes != 1) {
                 if (weaponType === "greatsword") {
                    source.runCommandAsync("playanimation @s animation.fast_paced.greatsword.charge_slash")
                 } else if (weaponType === "katana") {
                    source.runCommandAsync("playanimation @s animation.fast_paced_katana.charge_slash")
                 } else if (weaponType === "glaive") {
                    source.runCommandAsync("playanimation @s animation.fpd_glaive.charge_slash")
                 } else if (weaponType === "rapier") {
                    source.runCommandAsync("playanimation @s animation.fast_paced_rapier.charge_slash")
                 } else if (weaponType === "saber") {
                    source.runCommandAsync("playanimation @s animation.fast_paced_sabre.charge_slash")
                 } else if (weaponType === "longsword") {
                    source.runCommandAsync("playanimation @s animation.fast_paced_longsword.charge_slash")
                 } else if (weaponType === "wakizashi") {
                    source.runCommandAsync("playanimation @s animation.fast_paced_katana.charge_slash")
                 } else if (weaponType === "odachi") {
                    source.runCommandAsync("playanimation @s animation.fast_paced_odachi.charge_slash")
                 } else if (weaponType === "halberd") {
                    source.runCommandAsync("playanimation @s animation.fast_paced_halberd.charge_slash")
                 } else if (weaponType === "dagger") {
                    source.runCommandAsync("playanimation @s animation.fast_paced_dagger.charge_slash")
                 } 
              }
            break;
            case "Swing":
              let swnges = fetchScore(source, "swngcd");
              if (swnges != 1) {
                 if (weaponType === "mace") {
                    source.runCommandAsync("playanimation @s animation.fast_paced_mace.charge_swing")
                 } else if (weaponType === "pole_hammer") {
                    source.runCommandAsync("playanimation @s animation.fast_paced_polehammer.charge_swing")
                 }
              }
            break;
            case "Thrust":
              let thrstes = fetchScore(source, "thrstcd");
              if (thrstes != 1) {
                 if (weaponType === "lance") {
                    source.runCommandAsync("playanimation @s animation.fast_paced_lance.charge_thrust")
                 } else if (weaponType === "katar") {
                    source.runCommandAsync("playanimation @s animation.fast_paced_katar.charge_thrust")
                 } else if (weaponType === "rapier") {
                    source.runCommandAsync("playanimation @s animation.fast_paced_rapier.charge_thrust")
                 } else if (weaponType === "halberd") {
                    source.runCommandAsync("playanimation @s animation.fast_paced_halberd.charge_thrust")
                 } else if (weaponType === "spear") {
                    source.runCommandAsync("playanimation @s animation.fats_paced.spear.charge_thrust")
                 } else if (weaponType === "glaive") {
                    source.runCommandAsync("playanimation @s animation.fpd_glaive.charge_thrust")
                 }
              }
            break;
            case "Stab":
              let stbes = fetchScore(source, "stbcd");
              if (stbes != 1) {
                 if (weaponType === "dagger") {
                    source.runCommandAsync("playanimation @s animation.fast_paced_dagger.charge_stab")
                 }
              }
            break;
            case "Puncture":
              let pnctes = fetchScore(source, "pnctcd");
              if (pnctes != 1) {
                 if (weaponType === "lance") {
                    source.runCommandAsync("playanimation @s animation.fast_paced_lance.charge_puncture")
                 }
              }
            break;
            case "Pierce":
              let prces = fetchScore(source, "prccd");
              if (prces != 1) {
                 if (weaponType === "katar") {
                    source.runCommandAsync("playanimation @s animation.fast_paced_katar.charge_pierce")
                 }
              }
            break;
            case "Overhead Swing":
              let swngohes = fetchScore(source, "swngohcd");
              if (swngohes != 1) {
                 if (weaponType === "mace") {
                    source.runCommandAsync("playanimation @s animation.fast_paced_mace.charge_overhead_swing")
                 } else if (weaponType === "pole_hammer") {
                    source.runCommandAsync("playanimation @s animation.fast_paced_polehammer.charge_overhead_swing")
                 }
              }
            break;
            case "Guard":
              if (weaponType === "longsword") {
                source.runCommandAsync("playanimation @s animation.fast_paced_longsword.sword.ability_guard")
              } else if (weaponType === "saber") {
                source.runCommandAsync("playanimation @s animation.fast_paced_saber.sword.ability_guard")
              }
            break;
            case "Overhead Slash":
              let slshohes = fetchScore(source, "slshohcd");
              if (slshohes != 1) {
                 if (weaponType === "greatsword") {
                    source.runCommandAsync("playanimation @s animation.fast_paced.greatsword.charge_overhead_slash")
                 } else if (weaponType === "odachi") {
                    source.runCommandAsync("playanimation @s animation.fast_paced_odachi.charge_overhead_slash")
                 }
              }
            break;
            case "Iaido":
              let iaies = fetchScore(source, "iaicd");
              if (iaies != 1) {
                 if (weaponType === "wakizashi") {
                    source.runCommandAsync("playanimation @s animation.fast_paced_katana.charge_iaido")
                 } else if (weaponType === "katana") {
                    source.runCommandAsync("playanimation @s animation.fast_paced_katana.charge_iaido")
                 }
              }
              source.runCommandAsync("playanimation @s animation.fast_paced_katana.charge_iaido")
            break;
            case "Throw":
              let thrwes = fetchScore(source, "thrwcd");
              if (thrwes != 1) {
                 if (weaponType === "spear") {
                    source.runCommandAsync("playanimation @s animation.fats_paced.spear.charge_throw")
                 }
              }
            break;
          }
        }
    }
    system.clearRun(abilities)
    })
});

world.afterEvents.itemStopCharge.subscribe((data) => {
    let source = data.source
    let itemID = data.itemStack.typeId
    let weaponType = weaponTypeIterator(itemID)
    let loreCheck = data.itemStack.getLore();
    let loc = coordExtractor(source)
    const frontLoc = Vector.add(loc, Vector.multiply(source.getViewDirection(), 2));
    const cont = source.getComponent("minecraft:inventory").container
    const conts = cont.getSlot(source.selectedSlot)
    const item = conts.getItem();
    let ability = loreCheck[0].replace("§1","").replace("\n", "").replace("-","").split('§1')
    let second = ability[1].replace("-","")
    let first = ability[0]
    if (source.isSneaking) {
        switch (second){
          case "Slash":
            let slshs = fetchScore(source, "slshcd");
            if (slshs != 1) {
                 if (weaponType === "greatsword") {
                    source.runCommandAsync("playanimation @s animation.fast_paced.greatsword.ability_slash")
                 } else if (weaponType === "katana") {
                    source.runCommandAsync("playanimation @s animation.fast_paced_katana.ability_slash")
                 } else if (weaponType === "glaive") {
                    source.runCommandAsync("playanimation @s animation.fpd_glaive.ability_slash")
                 } else if (weaponType === "rapier") {
                    source.runCommandAsync("playanimation @s animation.fast_paced_rapier.ability_slash")
                 } else if (weaponType === "saber") {
                    source.runCommandAsync("playanimation @s animation.fast_paced_sabre.ability_slash")
                 } else if (weaponType === "longsword") {
                    source.runCommandAsync("playanimation @s animation.fast_paced_longsword.ability_slash")
                 } else if (weaponType === "wakizashi") {
                    source.runCommandAsync("playanimation @s animation.fast_paced_katana.ability_slash")
                 } else if (weaponType === "odachi") {
                    source.runCommandAsync("playanimation @s animation.fast_paced_odachi.ability_slash")
                 } else if (weaponType === "halberd") {
                    source.runCommandAsync("playanimation @s animation.fast_paced_halberd.ability_slash")
                 } else if (weaponType === "dagger") {
                    source.runCommandAsync("playanimation @s animation.fast_paced_dagger.ability_slash")
                 }
                source.runCommandAsync("scoreboard players remove @s exhaust 10")
                source.runCommandAsync("scoreboard players set @s exhregen 60")
                source.addTag("onegai")
                const projectile = world.getDimension("overworld").spawnEntity("pixel:slash_crescent",frontLoc)
                projectile.applyImpulse(source.getViewDirection());
                source.runCommandAsync("scoreboard players set @s slshcd 1")
                let slashcd = system.runInterval(() =>{
                    source.runCommandAsync("scoreboard players set @s slshcd 0")
                    system.clearRun(slashcd);
               },60);
            } 
          break;
          case "Swing":
            let swngs = fetchScore(source, "swngcd");
            if (swngs != 1) {
                 if (weaponType === "mace") {
                    source.runCommandAsync("playanimation @s animation.fast_paced_mace.ability_swing")
                 } else if (weaponType === "pole_hammer") {
                    source.runCommandAsync("playanimation @s animation.fast_paced_polehammer.ability_swing")
                 }
                source.runCommandAsync("scoreboard players remove @s exhaust 10")
                source.runCommandAsync("scoreboard players set @s exhregen 60")
                source.runCommandAsync("scoreboard players set @s swngcd 1")
                source.addTag("swdmg")
                source.runCommandAsync(`execute as @s run summon pixel:swing_damage ^^^1.5 damage:high`);
                let swngcd = system.runInterval(() =>{
                    source.runCommandAsync("scoreboard players set @s swngcd 0")
                    system.clearRun(swngcd);
               },60);
            } 
          break;
          case "Thrust":
            let thrsts = fetchScore(source, "thrstcd");
            if (thrsts != 1) {
                 if (weaponType === "lance") {
                    source.runCommandAsync("playanimation @s animation.fast_paced_lance.ability_thrust")
                 } else if (weaponType === "katar") {
                    source.runCommandAsync("playanimation @s animation.fast_paced_katar.ability_thrust")
                 } else if (weaponType === "halberd") {
                    source.runCommandAsync("playanimation @s animation.fast_paced_halberd.ability_thrust")
                 } else if (weaponType === "rapier") {
                    source.runCommandAsync("playanimation @s animation.fast_paced_rapier.ability_thrust")
                 } else if (weaponType === "spear") {
                    source.runCommandAsync("playanimation @s animation.fats_paced.spear.ability_thrust")
                 } else if (weaponType === "glaive") {
                    source.runCommandAsync("playanimation @s animation.fpd_glaive.ability_thrust")
                 }
                source.runCommandAsync("scoreboard players remove @s exhaust 10")
                source.runCommandAsync("scoreboard players set @s exhregen 60")
                source.addTag("thrst")
                source.runCommandAsync(`execute as @s run summon pixel:thrust_damage ^^^1.5`);
                source.runCommandAsync("scoreboard players set @s thrstcd 1")
                source.tryTeleport(frontLoc, source.dimension);
                let thrstcd = system.runInterval(() =>{
                    source.runCommandAsync("scoreboard players set @s thrstcd 0")
                    system.clearRun(thrstcd);
               },60);
            } 
          break;
          case "Stab":
            let stbs = fetchScore(source, "stbcd");
            if (stbs != 1) {
                 if (weaponType === "dagger") {
                    source.runCommandAsync("playanimation @s animation.fast_paced_dagger.ability_stab")
                 }
                source.runCommandAsync("scoreboard players remove @s exhaust 10")
                source.runCommandAsync("scoreboard players set @s exhregen 60")
                source.runCommandAsync("scoreboard players set @s stbcd 1")
                source.addTag("stab")
                source.runCommandAsync(`execute as @s run summon pixel:stab_damage ^^^1`);
                let stbcd = system.runInterval(() =>{
                    source.runCommandAsync("scoreboard players set @s stbcd 0")
                    system.clearRun(stbcd);
               },60);
            } 
          break;
          case "Puncture":
            let pncts = fetchScore(source, "pnctcd");
            if (pncts != 1) {
                 if (weaponType === "lance") {
                    source.runCommandAsync("playanimation @s animation.fast_paced_lance.ability_puncture")
                 }
                source.runCommandAsync("scoreboard players remove @s exhaust 10")
                source.runCommandAsync("scoreboard players set @s exhregen 60")
                source.runCommandAsync("scoreboard players set @s pnctcd 1")
                source.addTag("punture")
                source.runCommandAsync(`execute as @s run summon pixel:puncture_damage ^^^1`);
                let pnctcd = system.runInterval(() =>{
                    source.runCommandAsync("scoreboard players set @s pnctcd 0")
                    system.clearRun(pnctcd);
               },60);
            } 
          break;
          case "Pierce":
            let prcs = fetchScore(source, "prccd");
            if (prcs != 1) {
                 if (weaponType === "katar") {
                    source.runCommandAsync("playanimation @s animation.fast_paced_katar.ability_pierce")
                 }
                source.runCommandAsync("scoreboard players remove @s exhaust 10")
                source.runCommandAsync("scoreboard players set @s exhregen 60")
                source.addTag("pierce")
                source.runCommandAsync("scoreboard players set @s prccd 1")
                source.runCommandAsync(`execute as @s run summon pixel:pierce_damage ^^^1`);
                let prccd = system.runInterval(() =>{
                    source.runCommandAsync("scoreboard players set @s prccd 0")
                    system.clearRun(prccd);
               },60);
            } 
          break;
          case "Overhead Swing":
            let swngohs = fetchScore(source, "swngohcd");
            if (swngohs != 1) {
                 if (weaponType === "mace") {
                    source.runCommandAsync("playanimation @s animation.fast_paced_mace.ability_overhead_swing")
                 } else if (weaponType === "pole_hammer") {
                    source.runCommandAsync("playanimation @s animation.fast_paced_polehammer.ability_overhead_swing")
                 }
                source.runCommandAsync("scoreboard players remove @s exhaust 10")
                source.runCommandAsync("scoreboard players set @s exhregen 60")
                source.addTag("swknc")
                source.runCommandAsync(`execute as @s run summon pixel:swing_knock ^^^1.5 damage:high`);
                source.runCommandAsync("scoreboard players set @s swngohcd 1")
                let swngohcd = system.runInterval(() =>{
                    source.runCommandAsync("scoreboard players set @s swngohcd 0")
                    system.clearRun(swngohcd);
               },60);
            } 
          break;
          case "Overhead Slash":
            let slshohs = fetchScore(source, "swngohcd");
            if (slshohs != 1) {
                 if (weaponType === "greatsword") {
                    source.runCommandAsync("playanimation @s animation.fast_paced.greatsword.ability_overhead_slash")
                 } else if (weaponType === "odachi") {
                    source.runCommandAsync("playanimation @s animation.fast_paced_odachi.ability_overhead_slash")
                 }
                source.runCommandAsync("scoreboard players remove @s exhaust 10")
                source.runCommandAsync("scoreboard players set @s exhregen 60")
                source.runCommandAsync("scoreboard players set @s slshohcd 1")
                source.addTag("grslm")
                source.runCommandAsync(`execute as @s run summon pixel:ground_slash ^^^1.5 damage:high`);
                let slshohcd = system.runInterval(() =>{
                    source.runCommandAsync("scoreboard players set @s slshohcd 0")
                    system.clearRun(slshohcd);
               },60);
            } 
          break;
          case "Guard":
                source.addEffect("resistance", 100, { amplifier: 5, showParticle: false })
                source.runCommandAsync("scoreboard players remove @s exhaust 10")
                source.runCommandAsync("scoreboard players set @s exhregen 60")
          break;
          case "Iaido":
            let iais = fetchScore(source, "iaicd");
            if (iais != 1) {
                source.runCommandAsync("playanimation @s animation.fast_paced_katana.ability_iaido")
                let tgt = source.getEntitiesFromViewDirection({maxDistance: 7})[0];
                if (tgt == undefined) {
                   break;
                }
                source.runCommandAsync("scoreboard players remove @s exhaust 10")
                source.runCommandAsync("scoreboard players set @s exhregen 60")
                let trg = coordExtractor(tgt);
                const targetLoc = Vector.add(trg, Vector.multiply(source.getViewDirection(), 2));
                tgt.addEffect("weakness", 25, { amplifier: 100, showParticle: false })
                tgt.addEffect("slowness", 25, { amplifier: 100, showParticle: false })
                source.runCommandAsync("scoreboard players set @s iaicd 1")
                source.addTag("iai")
                source.tryTeleport(targetLoc, source.dimension);
                let btl = system.runInterval(() =>{
                   tgt.runCommandAsync(`execute as @s run summon pixel:iaido`)
                   system.clearRun(btl);
                },20);
                source.runCommandAsync("scoreboard players set @s iaicd 1")
                let iaicd = system.runInterval(() =>{
                    source.runCommandAsync("scoreboard players set @s iaicd 0")
                    system.clearRun(iaicd);
               },200);
            } 
          break;
          case "Throw":
            let thrws = fetchScore(source, "thrwcd");
            if (thrws != 1) {
                 if (weaponType === "spear") {
                    source.runCommandAsync("playanimation @s animation.fats_paced.spear.ability_throw")
                 }
                let mats = spearTypeIterator(itemID)
                source.runCommandAsync("scoreboard players remove @s exhaust 10")
                source.runCommandAsync("scoreboard players set @s exhregen 60")
                source.addTag("onegai")
                const spearProj = world.getDimension("overworld").spawnEntity(`pixel:${mats}_spear_throw`,frontLoc)
                spearProj.applyImpulse(source.getViewDirection());
                source.runCommandAsync("scoreboard players set @s thrwcd 1")
                let thrwcd = system.runInterval(() =>{
                    source.runCommandAsync("scoreboard players set @s thrwcd 0")
                    system.clearRun(thrwcd);
               },60);
            } 
          break;
      }
    } else {
        switch (first){
          case "Slash":
            let slshs = fetchScore(source, "slshcd");
            if (slshs != 1) {
                 if (weaponType === "greatsword") {
                    source.runCommandAsync("playanimation @s animation.fast_paced.greatsword.ability_slash")
                 } else if (weaponType === "katana") {
                    source.runCommandAsync("playanimation @s animation.fast_paced_katana.ability_slash")
                 } else if (weaponType === "glaive") {
                    source.runCommandAsync("playanimation @s animation.fpd_glaive.ability_slash")
                 } else if (weaponType === "rapier") {
                    source.runCommandAsync("playanimation @s animation.fast_paced_rapier.ability_slash")
                 } else if (weaponType === "saber") {
                    source.runCommandAsync("playanimation @s animation.fast_paced_sabre.ability_slash")
                 } else if (weaponType === "longsword") {
                    source.runCommandAsync("playanimation @s animation.fast_paced_longsword.ability_slash")
                 } else if (weaponType === "wakizashi") {
                    source.runCommandAsync("playanimation @s animation.fast_paced_katana.ability_slash")
                 } else if (weaponType === "odachi") {
                    source.runCommandAsync("playanimation @s animation.fast_paced_odachi.ability_slash")
                 } else if (weaponType === "halberd") {
                    source.runCommandAsync("playanimation @s animation.fast_paced_halberd.ability_slash")
                 } else if (weaponType === "dagger") {
                    source.runCommandAsync("playanimation @s animation.fast_paced_dagger.ability_slash")
                 }
                source.runCommandAsync("scoreboard players remove @s exhaust 10")
                source.runCommandAsync("scoreboard players set @s exhregen 60")
                source.addTag("onegai")
                const projectile = world.getDimension("overworld").spawnEntity("pixel:slash_crescent",frontLoc)
                projectile.applyImpulse(source.getViewDirection());
                source.runCommandAsync("scoreboard players set @s slshcd 1")
                let slashcd = system.runInterval(() =>{
                    source.runCommandAsync("scoreboard players set @s slshcd 0")
                    system.clearRun(slashcd);
               },60);
            } 
          break;
          case "Swing":
            let swngs = fetchScore(source, "swngcd");
            if (swngs != 1) {
                 if (weaponType === "mace") {
                    source.runCommandAsync("playanimation @s animation.fast_paced_mace.ability_swing")
                 } else if (weaponType === "pole_hammer") {
                    source.runCommandAsync("playanimation @s animation.fast_paced_polehammer.ability_swing")
                 }
                source.runCommandAsync("scoreboard players remove @s exhaust 10")
                source.runCommandAsync("scoreboard players set @s exhregen 60")
                source.runCommandAsync("scoreboard players set @s swngcd 1")
                source.addTag("swdmg")
                source.runCommandAsync(`execute as @s run summon pixel:swing_damage ^^^1.5 damage:high`);
                let swngcd = system.runInterval(() =>{
                    source.runCommandAsync("scoreboard players set @s swngcd 0")
                    system.clearRun(swngcd);
               },60);
            } 
          break;
          case "Thrust":
            let thrsts = fetchScore(source, "thrstcd");
            if (thrsts != 1) {
                 if (weaponType === "lance") {
                    source.runCommandAsync("playanimation @s animation.fast_paced_lance.ability_thrust")
                 } else if (weaponType === "katar") {
                    source.runCommandAsync("playanimation @s animation.fast_paced_katar.ability_thrust")
                 } else if (weaponType === "halberd") {
                    source.runCommandAsync("playanimation @s animation.fast_paced_halberd.ability_thrust")
                 } else if (weaponType === "rapier") {
                    source.runCommandAsync("playanimation @s animation.fast_paced_rapier.ability_thrust")
                 } else if (weaponType === "spear") {
                    source.runCommandAsync("playanimation @s animation.fats_paced.spear.ability_thrust")
                 } else if (weaponType === "glaive") {
                    source.runCommandAsync("playanimation @s animation.fpd_glaive.ability_thrust")
                 }
                source.runCommandAsync("scoreboard players remove @s exhaust 10")
                source.runCommandAsync("scoreboard players set @s exhregen 60")
                source.addTag("thrst")
                source.runCommandAsync(`execute as @s run summon pixel:thrust_damage ^^^1.5`);
                source.runCommandAsync("scoreboard players set @s thrstcd 1")
                source.tryTeleport(frontLoc, source.dimension);
                let thrstcd = system.runInterval(() =>{
                    source.runCommandAsync("scoreboard players set @s thrstcd 0")
                    system.clearRun(thrstcd);
               },60);
            } 
          break;
          case "Stab":
            let stbs = fetchScore(source, "stbcd");
            if (stbs != 1) {
                 if (weaponType === "dagger") {
                    source.runCommandAsync("playanimation @s animation.fast_paced_dagger.ability_stab")
                 }
                source.runCommandAsync("scoreboard players remove @s exhaust 10")
                source.runCommandAsync("scoreboard players set @s exhregen 60")
                source.runCommandAsync("scoreboard players set @s stbcd 1")
                source.addTag("stab")
                source.runCommandAsync(`execute as @s run summon pixel:stab_damage ^^^1`);
                let stbcd = system.runInterval(() =>{
                    source.runCommandAsync("scoreboard players set @s stbcd 0")
                    system.clearRun(stbcd);
               },60);
            } 
          break;
          case "Puncture":
            let pncts = fetchScore(source, "pnctcd");
            if (pncts != 1) {
                 if (weaponType === "lance") {
                    source.runCommandAsync("playanimation @s animation.fast_paced_lance.ability_puncture")
                 }
                source.runCommandAsync("scoreboard players remove @s exhaust 10")
                source.runCommandAsync("scoreboard players set @s exhregen 60")
                source.runCommandAsync("scoreboard players set @s pnctcd 1")
                source.addTag("punture")
                source.runCommandAsync(`execute as @s run summon pixel:puncture_damage ^^^1`);
                let pnctcd = system.runInterval(() =>{
                    source.runCommandAsync("scoreboard players set @s pnctcd 0")
                    system.clearRun(pnctcd);
               },60);
            } 
          break;
          case "Pierce":
            let prcs = fetchScore(source, "prccd");
            if (prcs != 1) {
                 if (weaponType === "katar") {
                    source.runCommandAsync("playanimation @s animation.fast_paced_katar.ability_pierce")
                 }
                source.runCommandAsync("scoreboard players remove @s exhaust 10")
                source.runCommandAsync("scoreboard players set @s exhregen 60")
                source.addTag("pierce")
                source.runCommandAsync("scoreboard players set @s prccd 1")
                source.runCommandAsync(`execute as @s run summon pixel:pierce_damage ^^^1`);
                let prccd = system.runInterval(() =>{
                    source.runCommandAsync("scoreboard players set @s prccd 0")
                    system.clearRun(prccd);
               },60);
            } 
          break;
          case "Overhead Swing":
            let swngohs = fetchScore(source, "swngohcd");
            if (swngohs != 1) {
                 if (weaponType === "mace") {
                    source.runCommandAsync("playanimation @s animation.fast_paced_mace.ability_overhead_swing")
                 } else if (weaponType === "pole_hammer") {
                    source.runCommandAsync("playanimation @s animation.fast_paced_polehammer.ability_overhead_swing")
                 }
                source.runCommandAsync("scoreboard players remove @s exhaust 10")
                source.runCommandAsync("scoreboard players set @s exhregen 60")
                source.addTag("swknc")
                source.runCommandAsync(`execute as @s run summon pixel:swing_knock ^^^1.5 damage:high`);
                source.runCommandAsync("scoreboard players set @s swngohcd 1")
                let swngohcd = system.runInterval(() =>{
                    source.runCommandAsync("scoreboard players set @s swngohcd 0")
                    system.clearRun(swngohcd);
               },60);
            } 
          break;
          case "Overhead Slash":
            let slshohs = fetchScore(source, "swngohcd");
            if (slshohs != 1) {
                 if (weaponType === "greatsword") {
                    source.runCommandAsync("playanimation @s animation.fast_paced.greatsword.ability_overhead_slash")
                 } else if (weaponType === "odachi") {
                    source.runCommandAsync("playanimation @s animation.fast_paced_odachi.ability_overhead_slash")
                 }
                source.runCommandAsync("scoreboard players remove @s exhaust 10")
                source.runCommandAsync("scoreboard players set @s exhregen 60")
                source.runCommandAsync("scoreboard players set @s slshohcd 1")
                source.addTag("grslm")
                source.runCommandAsync(`execute as @s run summon pixel:ground_slash ^^^1.5 damage:high`);
                let slshohcd = system.runInterval(() =>{
                    source.runCommandAsync("scoreboard players set @s slshohcd 0")
                    system.clearRun(slshohcd);
               },60);
            } 
          break;
          case "Guard":
                source.addEffect("resistance", 100, { amplifier: 5, showParticle: false })
                source.runCommandAsync("scoreboard players remove @s exhaust 10")
                source.runCommandAsync("scoreboard players set @s exhregen 60")
          break;
          case "Iaido":
            let iais = fetchScore(source, "iaicd");
            if (iais != 1) {
                let tgt = source.getEntitiesFromViewDirection({maxDistance: 7})[0];
                if (tgt == undefined) {
                   break;
                }
                source.runCommandAsync("scoreboard players remove @s exhaust 10")
                source.runCommandAsync("scoreboard players set @s exhregen 60")
                source.runCommandAsync("playanimation @s animation.fast_paced_katana.ability_iaido")
                let trg = coordExtractor(tgt);
                const targetLoc = Vector.add(trg, Vector.multiply(source.getViewDirection(), 2));
                tgt.addEffect("weakness", 25, { amplifier: 100, showParticle: false })
                tgt.addEffect("slowness", 25, { amplifier: 100, showParticle: false })
                source.runCommandAsync("scoreboard players set @s iaicd 1")
                source.addTag("iai")
                source.tryTeleport(targetLoc, source.dimension);
                let btl = system.runInterval(() =>{
                   tgt.runCommandAsync(`execute as @s run summon pixel:iaido`)
                   system.clearRun(btl);
                },20);
                source.runCommandAsync("scoreboard players set @s iaicd 1")
                let iaicd = system.runInterval(() =>{
                    source.runCommandAsync("scoreboard players set @s iaicd 0")
                    system.clearRun(iaicd);
               },200);
            } 
          break;
          case "Throw":
            let thrws = fetchScore(source, "thrwcd");
            if (thrws != 1) {
                 if (weaponType === "spear") {
                    source.runCommandAsync("playanimation @s animation.fats_paced.spear.ability_throw")
                 }
                let mats = spearTypeIterator(itemID)
                source.runCommandAsync("scoreboard players remove @s exhaust 10")
                source.runCommandAsync("scoreboard players set @s exhregen 60")
                source.addTag("onegai")
                const spearProj = world.getDimension("overworld").spawnEntity(`pixel:${mats}_spear_throw`,frontLoc)
                spearProj.applyImpulse(source.getViewDirection());
                source.runCommandAsync("scoreboard players set @s thrwcd 1")
                let thrwcd = system.runInterval(() =>{
                    source.runCommandAsync("scoreboard players set @s thrwcd 0")
                    system.clearRun(thrwcd);
               },60);
            } 
          break;
      }
    }
});

world.afterEvents.entityHurt.subscribe((entityData) => {
    const xtrdmg = Math.random()
    const mstr = Math.floor(Math.random()*3)
    const lncxh = Math.floor(Math.random()*3) + 2
    let cali = entityData.damageSource.damagingEntity
    let burn = entityData.hurtEntity
    let eA = enemyArmorCalculator(burn);
    let stunTime = Math.floor(10 - eA)
    let reaper = burn.getComponent("health").current;
    stunTime < 0 ? stunTime = 0 : stunTime = stunTime
    if (cali != undefined && cali.typeId !== "minecraft:player") {
      burn.addEffect("slowness", stunTime, { amplifier: 3, showParticle: false })
      burn.addEffect("weakness", stunTime, { amplifier: 100, showParticle: false })
        burn.runCommandAsync("execute as @s run scoreboard players set @s stunned 1");
      const lmao = system.runInterval(() => {
        burn.runCommandAsync("execute as @s run scoreboard players set @s stunned 0");
        system.clearRun(lmao);
      },stunTime);
    }
    if (cali != undefined && cali.typeId === "minecraft:player") {
         let cari = coordExtractor(cali);
         const targetLoc = Vector.add(cari, Vector.multiply(cali.getViewDirection(), 2));
         const inv = cali.getComponent("inventory").container.getItem(cali.selectedSlot);
         let polearm = fetchScore(cali, "plrm");
         let sword = fetchScore(cali, "swrdwpn");
         let light = fetchScore(cali, "lghtwpn");
         let great = fetchScore(cali, "grtwpn");
         let polearmxp = fetchScore(cali, "plrmxp");
         let swordxp = fetchScore(cali, "swrdwpnxp");
         let lightxp = fetchScore(cali, "lghtwpnxp");
         let greatxp = fetchScore(cali, "grtwpnxp");
         if (burn != undefined){
           if (inv == undefined) {
               return;
           }
           let blue = weaponTypeIterator(inv.typeId)
           switch (blue){
             case "lance":
               cali.runCommandAsync(`tell @s execution`);
               cali.runCommandAsync(`scoreboard players add @s plrmxp ${mstr}`);
               if (polearmxp > 1500 && polearm < 1) {
                   cali.runCommandAsync(`scoreboard players set @s plrm 1`);
               }
               if (polearmxp > 4500 && polearm < 2) {
                   cali.runCommandAsync(`scoreboard players set @s plrm 2`);
               }
               if (polearmxp > 10000 && polearm < 3) {
                   cali.runCommandAsync(`scoreboard players set @s plrm 3`);
               }
               stunTime = stunTime + 3
               stunTime < 0 ? stunTime = 0 : stunTime = stunTime
               //cali.teleport(newLoc, cali.dimension, cali.rotation.x, cali.rotation.y);
               cali.runCommandAsync(`execute as @s run function weapons/lance/lance_mastery_${polearm}`);
               burn.addEffect("slowness", stunTime, { amplifier: 3, showParticle: false })
               burn.addEffect("weakness", stunTime, { amplifier: 100, showParticle: false })
               burn.runCommandAsync("execute as @s run scoreboard players set @s stunned 1");
               const lmaobruh = system.runInterval(() => {
                 burn.runCommandAsync("execute as @s run scoreboard players set @s stunned 0");
                 system.clearRun(lmaobruh);
               },stunTime);
             break;
             case "katana":
               cali.runCommandAsync(`scoreboard players add @s swrdwpnxp ${mstr}`);
               if (swordxp > 1500 && sword < 1) {
                   cali.runCommandAsync(`scoreboard players set @s swrdwpn 1`);
               }
               if (swordxp > 4500 && sword < 2) {
                   cali.runCommandAsync(`scoreboard players set @s swrdwpn 2`);
               }
               if (swordxp > 10000 && sword < 3) {
                   cali.runCommandAsync(`scoreboard players set @s swrdwpn 3`);
               }
               cali.runCommandAsync(`execute as @s run function weapons/katana/katana_mastery_${sword}`);
               stunTime = stunTime - 5
               stunTime < 0 ? stunTime = 0 : stunTime = stunTime
               burn.addEffect("slowness", stunTime, { amplifier: 3, showParticle: false })
               burn.addEffect("weakness", stunTime, { amplifier: 100, showParticle: false })
               burn.runCommandAsync("execute as @s run scoreboard players set @s stunned 1");
               const lmaobruhs = system.runInterval(() => {
                 burn.runCommandAsync("execute as @s run scoreboard players set @s stunned 0");
                 system.clearRun(lmaobruhs);
               },stunTime);
               //if (reaper <= 5) {
                   //cali.teleport(targetLoc, cali.dimension);
               //};
             break;
             case "mace":
               cali.runCommandAsync(`scoreboard players add @s lghtwpnxp ${mstr}`);
               cali.runCommandAsync(`execute as @s run function weapons/mace/mace_mastery_${light}`);
               stunTime = stunTime + 10
               stunTime < 0 ? stunTime = 0 : stunTime = stunTime
               burn.addEffect("slowness", stunTime, { amplifier: 3, showParticle: false })
               burn.addEffect("weakness", stunTime, { amplifier: 100, showParticle: false })
               const lmaobruha = system.runInterval(() => {
                  burn.runCommandAsync("execute as @s run scoreboard players set @s stunned 0");
                  system.clearRun(lmaobruha);
             },stunTime);
             break;
             case "halberd":
               cali.runCommandAsync(`scoreboard players add @s plrmxp ${mstr}`);
               if (polearmxp > 1500 && polearm < 1) {
                   cali.runCommandAsync(`scoreboard players set @s plrm 1`);
               }
               if (polearmxp > 4500 && polearm < 2) {
                   cali.runCommandAsync(`scoreboard players set @s plrm 2`);
               }
               if (polearmxp > 10000 && polearm < 3) {
                   cali.runCommandAsync(`scoreboard players set @s plrm 3`);
               }
               cali.runCommandAsync(`execute as @s run function weapons/halberd/halberd_mastery_${polearm}`);
               stunTime = stunTime + 5
               stunTime < 0 ? stunTime = 0 : stunTime = stunTime
               burn.addEffect("slowness", stunTime, { amplifier: 3, showParticle: false })
               burn.addEffect("weakness", stunTime, { amplifier: 100, showParticle: false })
               burn.runCommandAsync("execute as @s run scoreboard players set @s stunned 1");
               const lmaobruhd = system.runInterval(() => {
                 burn.runCommandAsync("execute as @s run scoreboard players set @s stunned 0");
                 system.clearRun(lmaobruhd);
               },stunTime);
             break;
             case "greatsword":
               cali.runCommandAsync(`scoreboard players add @s grtwpnxp ${mstr}`);
               if (greatxp > 1500 && sword < 1) {
                   cali.runCommandAsync(`scoreboard players set @s grtwpn 1`);
               }
               if (greatxp > 4500 && great < 2) {
                   cali.runCommandAsync(`scoreboard players set @s grtwpn 2`);
               }
               if (greatxp > 10000 && great < 3) {
                   cali.runCommandAsync(`scoreboard players set @s grtwpn 3`);
               }
               cali.runCommandAsync(`execute as @s run function weapons/greatsword/greatsword_mastery_${great}`);
               stunTime = stunTime + 7
               stunTime < 0 ? stunTime = 0 : stunTime = stunTime
               burn.addEffect("slowness", stunTime, { amplifier: 3, showParticle: false })
               burn.addEffect("weakness", stunTime, { amplifier: 100, showParticle: false })
               burn.runCommandAsync("execute as @s run scoreboard players set @s stunned 1");
               const lmaobruhf = system.runInterval(() => {
                 burn.runCommandAsync("execute as @s run scoreboard players set @s stunned 0");
                 system.clearRun(lmaobruhf);
               },stunTime);
             break;
             case "longsword":
               stunTime = stunTime - 3
               stunTime < 0 ? stunTime = 0 : stunTime = stunTime
               cali.runCommandAsync(`scoreboard players add @s swrdwpnxp ${mstr}`);
               if (swordxp > 1500 && sword < 1) {
                   cali.runCommandAsync(`scoreboard players set @s swrdwpn 1`);
               }
               if (swordxp > 4500 && sword < 2) {
                   cali.runCommandAsync(`scoreboard players set @s swrdwpn 2`);
               }
               if (swordxp > 10000 && sword < 3) {
                   cali.runCommandAsync(`scoreboard players set @s swrdwpn 3`);
               }
               cali.runCommandAsync(`execute as @s run function weapons/longsword/longsword_mastery_${sword}`);
               burn.addEffect("slowness", stunTime, { amplifier: 3, showParticle: false })
               burn.addEffect("weakness", stunTime, { amplifier: 100, showParticle: false })
               burn.runCommandAsync("execute as @s run scoreboard players set @s stunned 1");
               const lmaobruf = system.runInterval(() => {
                 burn.runCommandAsync("execute as @s run scoreboard players set @s stunned 0");
                 system.clearRun(lmaobruf);
               },stunTime);
             break;
             case "saber":
               stunTime = stunTime - 2
               stunTime < 0 ? stunTime = 0 : stunTime = stunTime
               cali.runCommandAsync(`scoreboard players add @s swrdwpnxp ${mstr}`);
               if (swordxp > 1500 && sword < 1) {
                   cali.runCommandAsync(`scoreboard players set @s swrdwpn 1`);
               }
               if (swordxp > 4500 && sword < 2) {
                   cali.runCommandAsync(`scoreboard players set @s swrdwpn 2`);
               }
               if (swordxp > 10000 && sword < 3) {
                   cali.runCommandAsync(`scoreboard players set @s swrdwpn 3`);
               }
               cali.runCommandAsync(`execute as @s run function weapons/saber/saber_mastery_${sword}`);
               burn.addEffect("slowness", stunTime, { amplifier: 3, showParticle: false })
               burn.addEffect("weakness", stunTime, { amplifier: 100, showParticle: false })
               burn.runCommandAsync("execute as @s run scoreboard players set @s stunned 1");
               const lmaobruhg = system.runInterval(() => {
                 burn.runCommandAsync("execute as @s run scoreboard players set @s stunned 0");
                 system.clearRun(lmaobruhg);
               },stunTime);
             break;
             case "odachi":
               cali.runCommandAsync(`scoreboard players add @s grtwpnxp ${mstr}`);
               if (greatxp > 1500 && sword < 1) {
                   cali.runCommandAsync(`scoreboard players set @s grtwpn 1`);
               }
               if (greatxp > 4500 && great < 2) {
                   cali.runCommandAsync(`scoreboard players set @s grtwpn 2`);
               }
               if (greatxp > 10000 && great < 3) {
                   cali.runCommandAsync(`scoreboard players set @s grtwpn 3`);
               }
               cali.runCommandAsync(`execute as @s run function weapons/odachi/odachi_mastery_${great}`);
               stunTime = stunTime + 2
               stunTime < 0 ? stunTime = 0 : stunTime = stunTime
               burn.addEffect("slowness", stunTime, { amplifier: 3, showParticle: false })
               burn.addEffect("weakness", stunTime, { amplifier: 100, showParticle: false })
               burn.runCommandAsync("execute as @s run scoreboard players set @s stunned 1");
               const lmaobrug = system.runInterval(() => {
                 burn.runCommandAsync("execute as @s run scoreboard players set @s stunned 0");
                 system.clearRun(lmaobrug);
               },stunTime);
             break;
             case "dagger":
               cali.runCommandAsync(`scoreboard players add @s lghtwpnxp ${mstr}`);
               if (lightxp > 1500 && lightarm < 1) {
                   cali.runCommandAsync(`scoreboard players set @s lghtwpn 1`);
               }
               if (lightxp > 4500 && lightarm < 2) {
                   cali.runCommandAsync(`scoreboard players set @s lghtwpn 2`);
               }
               if (lightxp > 10000 && light < 3) {
                   cali.runCommandAsync(`scoreboard players set @s lghtwpn 3`);
               }
               cali.runCommandAsync(`execute as @s run function weapons/dagger/dagger_mastery_${light}`);
               stunTime = stunTime - 7
               stunTime < 0 ? stunTime = 0 : stunTime = stunTime
               burn.addEffect("slowness", stunTime, { amplifier: 3, showParticle: false })
               burn.addEffect("weakness", stunTime, { amplifier: 100, showParticle: false })
               burn.runCommandAsync("execute as @s run scoreboard players set @s stunned 1");
               const lmaobruhh = system.runInterval(() => {
                 burn.runCommandAsync("execute as @s run scoreboard players set @s stunned 0");
                 system.clearRun(lmaobruhh);
               },stunTime);
             break;
             case "katar":
               cali.runCommandAsync(`scoreboard players add @s lghtwpnxp ${mstr}`);
               if (lightxp > 1500 && lightarm < 1) {
                   cali.runCommandAsync(`scoreboard players set @s lghtwpn 1`);
               }
               if (lightxp > 4500 && lightarm < 2) {
                   cali.runCommandAsync(`scoreboard players set @s lghtwpn 2`);
               }
               if (lightxp > 10000 && light < 3) {
                   cali.runCommandAsync(`scoreboard players set @s lghtwpn 3`);
               }
               cali.runCommandAsync(`execute as @s run function weapons/katar/katar_mastery_${light}`);
               stunTime = stunTime - 5
               stunTime < 0 ? stunTime = 0 : stunTime = stunTime
               burn.addEffect("slowness", stunTime, { amplifier: 3, showParticle: false })
               burn.addEffect("weakness", stunTime, { amplifier: 100, showParticle: false })
               burn.runCommandAsync("execute as @s run scoreboard players set @s stunned 1");
               const lmaobruhj = system.runInterval(() => {
                 burn.runCommandAsync("execute as @s run scoreboard players set @s stunned 0");
                 system.clearRun(lmaobruhj);
               },stunTime);
             break;
             case "rapier":
               cali.runCommandAsync(`scoreboard players add @s swrdwpnxp ${mstr}`);
               if (swordxp > 1500 && sword < 1) {
                   cali.runCommandAsync(`scoreboard players set @s swrdwpn 1`);
               }
               if (swordxp > 4500 && sword < 2) {
                   cali.runCommandAsync(`scoreboard players set @s swrdwpn 2`);
               }
               if (swordxp > 10000 && sword < 3) {
                   cali.runCommandAsync(`scoreboard players set @s swrdwpn 3`);
               }
               cali.runCommandAsync(`execute as @s run function weapons/rapier/rapier_mastery_${sword}`);
               stunTime = stunTime - 3
               stunTime < 0 ? stunTime = 0 : stunTime = stunTime
               burn.addEffect("slowness", stunTime, { amplifier: 3, showParticle: false })
               burn.addEffect("weakness", stunTime, { amplifier: 100, showParticle: false })
               burn.runCommandAsync("execute as @s run scoreboard players set @s stunned 1");
               const lmaobruj = system.runInterval(() => {
                 burn.runCommandAsync("execute as @s run scoreboard players set @s stunned 0");
                 system.clearRun(lmaobruj);
               },stunTime);
             break;
             case "wakizashi":
               cali.runCommandAsync(`scoreboard players add @s lghtwpnxp ${mstr}`);
               if (lightxp > 1500 && lightarm < 1) {
                   cali.runCommandAsync(`scoreboard players set @s lghtwpn 1`);
               }
               if (lightxp > 4500 && lightarm < 2) {
                   cali.runCommandAsync(`scoreboard players set @s lghtwpn 2`);
               }
               if (lightxp > 10000 && light < 3) {
                   cali.runCommandAsync(`scoreboard players set @s lghtwpn 3`);
               }
               cali.runCommandAsync(`execute as @s run function weapons/wakizashi/wakizashi_mastery_${light}`);
               stunTime = stunTime - 7
               stunTime < 0 ? stunTime = 0 : stunTime = stunTime
               burn.addEffect("slowness", stunTime, { amplifier: 3, showParticle: false })
               burn.addEffect("weakness", stunTime, { amplifier: 100, showParticle: false })
               burn.runCommandAsync("execute as @s run scoreboard players set @s stunned 1");
               const lmaobruhk = system.runInterval(() => {
                 burn.runCommandAsync("execute as @s run scoreboard players set @s stunned 0");
                 system.clearRun(lmaobruhk);
               },stunTime);
             break;
             case "spear":
               cali.runCommandAsync(`scoreboard players add @s plrmxp ${mstr}`);
               if (polearmxp > 1500 && polearm < 1) {
                   cali.runCommandAsync(`scoreboard players set @s plrm 1`);
               }
               if (polearmxp > 4500 && polearm < 2) {
                   cali.runCommandAsync(`scoreboard players set @s plrm 2`);
               }
               if (polearmxp > 10000 && polearm < 3) {
                   cali.runCommandAsync(`scoreboard players set @s plrm 3`);
               }
               stunTime = stunTime + 3
               stunTime < 0 ? stunTime = 0 : stunTime = stunTime
               cali.runCommandAsync(`execute as @s run function weapons/spear/spear_mastery_${polearm}`);
               burn.addEffect("slowness", stunTime, { amplifier: 3, showParticle: false })
               burn.addEffect("weakness", stunTime, { amplifier: 100, showParticle: false })
               burn.runCommandAsync("execute as @s run scoreboard players set @s stunned 1");
               const lmaobruk = system.runInterval(() => {
                 burn.runCommandAsync("execute as @s run scoreboard players set @s stunned 0");
                 system.clearRun(lmaobruk);
               },stunTime);
             break;
             case "glaive":
               cali.runCommandAsync(`scoreboard players add @s plrmxp ${mstr}`);
               if (polearmxp > 1500 && polearm < 1) {
                   cali.runCommandAsync(`scoreboard players set @s plrm 1`);
               }
               if (polearmxp > 4500 && polearm < 2) {
                   cali.runCommandAsync(`scoreboard players set @s plrm 2`);
               }
               if (polearmxp > 10000 && polearm < 3) {
                   cali.runCommandAsync(`scoreboard players set @s plrm 3`);
               }
               stunTime = stunTime + 3
               stunTime < 0 ? stunTime = 0 : stunTime = stunTime
               cali.runCommandAsync(`execute as @s run function weapons/glaive/glaive_mastery_${polearm}`);
               burn.addEffect("slowness", stunTime, { amplifier: 3, showParticle: false })
               burn.addEffect("weakness", stunTime, { amplifier: 100, showParticle: false })
               burn.runCommandAsync("execute as @s run scoreboard players set @s stunned 1");
               const lmaobruhl = system.runInterval(() => {
                 burn.runCommandAsync("execute as @s run scoreboard players set @s stunned 0");
                 system.clearRun(lmaobruhl);
               },stunTime);
             break;
             case "pole_hammer":
               cali.runCommandAsync(`scoreboard players add @s plrmxp ${mstr}`);
               if (polearmxp > 1500 && polearm < 1) {
                   cali.runCommandAsync(`scoreboard players set @s plrm 1`);
               }
               if (polearmxp > 4500 && polearm < 2) {
                   cali.runCommandAsync(`scoreboard players set @s plrm 2`);
               }
               if (polearmxp > 10000 && polearm < 3) {
                   cali.runCommandAsync(`scoreboard players set @s plrm 3`);
               }
               stunTime = stunTime + 15
               stunTime < 0 ? stunTime = 0 : stunTime = stunTime
               cali.runCommandAsync(`execute as @s run function weapons/polehammer/polehammer_mastery_${polearm}`);
               burn.addEffect("slowness", stunTime, { amplifier: 3, showParticle: false })
               burn.addEffect("weakness", stunTime, { amplifier: 100, showParticle: false })
               burn.runCommandAsync("execute as @s run scoreboard players set @s stunned 1");
               if (burn.typeId == "minecraft:player"){
               const lmaobrul = system.runInterval(() => {
                 burn.runCommandAsync("execute as @s run scoreboard players set @s stunned 0");
                 system.clearRun(lmaobrul);
               },stunTime);
               }
             break;
             case "corbin":
               cali.runCommandAsync(`scoreboard players add @s plrmxp ${mstr}`);
               if (polearmxp > 1500 && polearm < 1) {
                   cali.runCommandAsync(`scoreboard players set @s plrm 1`);
               }
               if (polearmxp > 4500 && polearm < 2) {
                   cali.runCommandAsync(`scoreboard players set @s plrm 2`);
               }
               if (polearmxp > 10000 && polearm < 3) {
                   cali.runCommandAsync(`scoreboard players set @s plrm 3`);
               }
               stunTime = stunTime + 7
               stunTime < 0 ? stunTime = 0 : stunTime = stunTime
               cali.runCommandAsync(`execute as @s run function weapons/bec_de_corbin/bec_de_corbin_mastery_${polearm}`);
               burn.addEffect("slowness", stunTime, { amplifier: 3, showParticle: false })
               burn.addEffect("weakness", stunTime, { amplifier: 100, showParticle: false })
               burn.runCommandAsync("execute as @s run scoreboard players set @s stunned 1");
               const lmaobrum = system.runInterval(() => {
                 burn.runCommandAsync("execute as @s run scoreboard players set @s stunned 0");
                 system.clearRun(lmaobrum);
               },stunTime);
             break;
       }
     }
   } else return;
});